/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.client;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.common.homelibrary.client.FTPFile;
import org.gcube.common.homelibrary.client.servlet.Servlets;

public class FTPClient {
    private static final String SEPARATOR = "/";
    private String rootPath = "/Share/08f2ea9b-c6a0-4533-ae21-32cb6138da4c";

    public String getRootPath() throws Exception {
        if (this.rootPath == null || !this.rootPath.contains("/Share/08f2ea9b-c6a0-4533-ae21-32cb6138da4c")) {
            throw new Exception("current directory not set");
        }
        return this.rootPath;
    }

    private boolean exists(String dir, String absPath) {
        try {
            Servlets.listFolder(String.valueOf(absPath) + File.separator + dir);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void delete(String absPath) throws Exception {
        if (absPath == "/Share/08f2ea9b-c6a0-4533-ae21-32cb6138da4c") {
            throw new Exception("Root cannot be deleted");
        }
        if (!absPath.contains("/Share/08f2ea9b-c6a0-4533-ae21-32cb6138da4c")) {
            throw new Exception(String.valueOf(this.getRootPath()) + " cannot be deleted");
        }
        Boolean flag = Servlets.delete(absPath);
        if (!flag.booleanValue()) {
            throw new Exception("Impossible to delete " + absPath);
        }
    }

    public FTPFile[] list(String absPath) throws Exception {
        FTPFile[] list = null;
        try {
            Map<String, Boolean> files = Servlets.listFolder(absPath);
            list = new FTPFile[files.size()];
            int i = 0;
            Set<String> keys = files.keySet();
            for (String key : keys) {
                Boolean isFolder = files.get(key);
                list[i] = new FTPFile(String.valueOf(absPath) + SEPARATOR + key, isFolder);
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception("Impossible to list " + absPath + ": " + e.getMessage());
        }
        return list;
    }

    public void createDirectory(String directoryName, String description, String absPath) throws Exception {
        try {
            if (this.exists(directoryName, absPath)) {
                throw new Exception(String.valueOf(directoryName) + " already exists");
            }
            Servlets.createFolder(directoryName, description, absPath);
        }
        catch (Exception e) {
            throw new Exception("Impossible to create Directory " + directoryName + ": " + e.getMessage());
        }
    }

    public void upload(byte[] bFile, String name, String description, String absPath) throws Exception {
        try {
            Servlets.uploadFile(bFile, name, description, absPath, null, 0L);
        }
        catch (Exception e) {
            throw new Exception("Impossible to upload file " + name + ": " + e.getMessage());
        }
    }

    public void upload(byte[] bFile, String name, String description, String absPath, String mimetype, long size) throws Exception {
        try {
            Servlets.uploadFile(bFile, name, description, absPath, mimetype, size);
        }
        catch (Exception e) {
            throw new Exception("Impossible to upload file " + name + ": " + e.getMessage());
        }
    }

    public void test() throws Exception {
        FTPFile[] list;
        FTPClient client = new FTPClient();
        System.out.println("Current dir " + client.getRootPath());
        System.out.println("List Root ");
        FTPFile[] fTPFileArray = list = client.list(client.getRootPath());
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile item = fTPFileArray[n2];
            System.out.println("* " + item.getName() + " is folder? " + item.isFolder());
            ++n2;
        }
        System.out.println("\n\n");
        String A_name = "A-" + UUID.randomUUID().toString();
        String B_name = "B-" + UUID.randomUUID().toString();
        client.createDirectory(A_name, "test A in ROOT", client.getRootPath());
        System.out.println("Folder " + A_name + " created in " + client.getRootPath());
        System.out.println("\n\n");
        client.createDirectory(B_name, "test A in ROOT", "/Share/08f2ea9b-c6a0-4533-ae21-32cb6138da4c/" + A_name);
        System.out.println("Folder " + B_name + " created in " + client.getRootPath());
        System.out.println("\n\n");
        System.out.println("Save images in /Share/08f2ea9b-c6a0-4533-ae21-32cb6138da4c/" + A_name + SEPARATOR + B_name);
        URL imageURL = FTPClient.class.getClassLoader().getResource("org/gcube/common/homelibrary/client/2016-05-05_2016-05-05_16_04.jpg");
        File file = new File(imageURL.getFile());
        int i = 0;
        while (i < 5) {
            byte[] image = Files.readAllBytes(file.toPath());
            client.upload(image, "img-" + UUID.randomUUID().toString() + ".jpg", "my description", "/Share/08f2ea9b-c6a0-4533-ae21-32cb6138da4c/" + A_name + SEPARATOR + B_name, "image/jpeg", 3000L);
            ++i;
        }
        System.out.println("\n\n");
        System.out.println("\n\n");
        System.out.println("HL CLI test successfully completed. ");
    }
}

