package org.gcube.common.homelibrary.client.servlet;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

import org.gcube.common.homelibrary.client.util.Config;
import org.gcube.common.homelibrary.client.util.TokenUtility;

import com.thoughtworks.xstream.XStream;

public class Servlets {

	/**
	 * Delete files or folder
	 * @param absPath absolute path of the item to delete
	 * @return true if the file/folder has been deleted
	 * @throws Exception
	 */
	public static Boolean delete(String absPath) throws Exception{
		XStream xstream = null;
		String xmlOut = null;
		Boolean flag = false;
		try{
			String uri = Config.URL_REPOSITORY + "/rest/Delete?absPath=" +  URLEncoder.encode(absPath, "UTF-8") ;
//			System.out.println(uri);
			URL url = new URL(uri);
			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setRequestMethod("POST");
			connection.setRequestProperty("Accept", "application/xml");
			TokenUtility.setHeader(connection);


			int responseCode = connection.getResponseCode();
			//			System.out.println("\nSending 'POST' request to URL : " + url);
			//			System.out.println("Post parameters : " + urlParameters);
			System.out.println("Response Code : " + responseCode);

			xstream = new XStream();

			BufferedReader in = new BufferedReader(
					new InputStreamReader(connection.getInputStream()));

			StringBuffer response = new StringBuffer();
			String inputLine;
			while ((inputLine = in.readLine()) != null) {
				response.append(inputLine);
			}
			in.close();

			xmlOut = response.toString();
			System.out.println(xmlOut);

			connection.disconnect();


			flag = (Boolean) xstream.fromXML(xmlOut);


		} catch (ClassCastException e) {

			throw new Exception(e.getMessage());
		} 

		return flag;

	}
	
	
	
	/**
	 * Save a file
	 * @param in
	 * @param name
	 * @param description
	 * @param parentPath
	 * @param mimetype
	 * @param size
	 * @return
	 * @throws Exception
	 */
	public static String uploadFile(byte[] in, String name, String description, String parentPath, String mimetype, long size) throws Exception {
		XStream xstream = new XStream();

		System.out.println("Upload File " + name);

		String uri = Config.URL_REPOSITORY + "/rest/Upload?name=" + name+ "&description=" + URLEncoder.encode(description, "UTF-8") + "&parentPath=" + URLEncoder.encode(parentPath, "UTF-8") + "&mimetype=" + mimetype + "&size=" + String.valueOf(size);
		
//		System.out.println(uri);
		URL url = new URL(uri);
		HttpURLConnection connection = (HttpURLConnection)url.openConnection();
		connection.setDoInput(true);
		connection.setDoOutput(true);
		connection.setUseCaches(false);
		connection.setRequestProperty("Content-Type", "image/jpeg");
		connection.setRequestMethod("POST");
		TokenUtility.setHeader(connection);
		
		// Write file to response.
	    OutputStream output = connection.getOutputStream();
	    output.write(in);
	    output.close();
	    
		BufferedReader r = new BufferedReader(new  InputStreamReader(connection.getInputStream()));

		StringBuffer response = new StringBuffer();
		String inputLine;
		while ((inputLine = r.readLine()) != null) {
			response.append(inputLine);
		}

		String xmlOut = response.toString();
		return (String) xstream.fromXML(xmlOut);
	}



//	/**
//	 * Save a file
//	 * @param path
//	 * @param name
//	 * @param description
//	 * @param parentPath
//	 * @return
//	 * @throws Exception
//	 */
//	public static String uploadFile(File file, String name, String description, String parentPath, String charset) throws Exception {
//
//		//		System.out.println("Save file " + name +  " in " + parentPath);
//
//		StringBuffer res = new StringBuffer();
//		XStream xstream = new XStream();
//		try {
//
//			if (name==null)
//				name = file.getName();
//
//			//			File uploadFile1 = new File(path);
//
//			String requestURL = Config.HTTP_URL_REPOSITORY + "/post/UploadFile?&filename=" + file.getName()+ "&name=" + name+ "&description=" + URLEncoder.encode(description, "UTF-8") + "&parentPath=" + URLEncoder.encode(parentPath, "UTF-8");
//			MultipartUtility multipart = new MultipartUtility(requestURL, charset);
//
//			multipart.addHeaderField("User-Agent", "CodeJava");
//			multipart.addHeaderField("Test-Header", "Header-Value");
//			multipart.addFormField("description", "upload file");
//			multipart.addFilePart("fileUpload", file);
//			TokenUtility.setHeader(multipart);
//
//			List<String> response = multipart.finish();
//
//			for (String line : response) {
//				res.append(line);
//			}
//
//		} catch (IOException e) {
//			throw new Exception(e.getMessage());
//		} 
//
//		return (String) xstream.fromXML(res.toString());
//	}


	/**
	 * Create a folder
	 * @param name
	 * @param description
	 * @param parentPath
	 * @return
	 * @throws Exception
	 */
	public static String createFolder(String name, String description,
			String parentPath) throws Exception {

		System.out.println("Create Folder " + name);
		String uri = Config.URL_REPOSITORY + "/rest/CreateFolder?name=" + name+ "&description=" + URLEncoder.encode(description, "UTF-8") + "&parentPath=" + URLEncoder.encode(parentPath, "UTF-8");
//	System.out.println(uri);
		URL url = new URL(uri);
		HttpURLConnection connection = (HttpURLConnection) url.openConnection();
		connection.setRequestMethod("POST");
		connection.setRequestProperty("Accept", "application/xml");
		TokenUtility.setHeader(connection);

		int responseCode = connection.getResponseCode();
		//		System.out.println("\nSending 'POST' request to URL : " + url);
		//		System.out.println("Post parameters : " + urlParameters);
		System.out.println("Response Code : " + responseCode);

		XStream xstream = new XStream();

		BufferedReader in = new BufferedReader(
				new InputStreamReader(connection.getInputStream()));

		StringBuffer response = new StringBuffer();
		String inputLine;
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();

		String xmlOut = response.toString();
		System.out.println(xmlOut);

		connection.disconnect();
		return (String) xstream.fromXML(xmlOut);

	}

	/**
	 * List content of a folder
	 * @param absPath
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Map<String, Boolean> listFolder(String absPath) throws Exception {

		System.out.println("Calling servlet list folder " + absPath);
		XStream xstream = new XStream();
		String xmlOut = null;
		Map<String, Boolean> list = null;
		try{
			String uri = Config.URL_REPOSITORY + "/rest/List?absPath=" + URLEncoder.encode(absPath, "UTF-8");
System.out.println(uri);
//uri = "http://node11.d.d4science.research-infrastructures.eu:80/home-library-webapp/rest/List?absPath=/Share/042efb85-240b-4a04-93d3-bca3924b7503/camera02";
			URL url = new URL(uri);
			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			TokenUtility.setHeader(connection);
			connection.setRequestMethod("GET");
			connection.setRequestProperty("Accept", "application/xml");
			

			int responseCode = connection.getResponseCode();
			//		System.out.println("\nSending 'GET' request to URL : " + uri);
			System.out.println("Response Code : " + responseCode);



			BufferedReader in = new BufferedReader(
					new InputStreamReader(connection.getInputStream()));

			StringBuffer response = new StringBuffer();
			String inputLine;
			while ((inputLine = in.readLine()) != null) {
				response.append(inputLine);
			}
			in.close();

			xmlOut = response.toString();
//			System.out.println(xmlOut);

			connection.disconnect();

			System.out.println(xstream.fromXML(xmlOut));
			list = (Map<String, Boolean>) xstream.fromXML(xmlOut);

		} catch (ClassCastException e) {
			throw new Exception(e.getMessage());
		} 

		return list;

	}


}
