/**
 * 
 */
package org.gcube.data.gml.elements;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;


/**
 * @author Fabio Simeoni (University of Strathclyde)
 *
 */
public class AnnotationElements extends InnerElements<GCubeAnnotation> {

	AnnotationElements(GCubeDocument doc, List<GCubeAnnotation> es) {
		super(doc,es);
	}
	
	/**
	 * Removes an annotation and the annotation that follow it in the thread, if any.
	 * @param a the annotation.
	 * @throws IllegalStateException if an annotation with the given identifier does not exist.
	 */
	public void removeFromThread(GCubeAnnotation a) throws IllegalStateException {
		super.remove(a);
		for (GCubeAnnotation anno : this.toList())
			if (anno.previous()!=null && anno.previous().equals(a))
				remove(anno);
		
	}
	
	/**
	 * Removes an annotation and the annotation that follow it in the thread, if any.
	 * @param id the annotation identifier.
	 * @return the removed annotation.
	 * @throws IllegalStateException if an annotation with the given identifier does not exist.
	 */
	public GCubeAnnotation removeFromThread(String id) throws IllegalStateException {
		GCubeAnnotation removed = get(id);
		removeFromThread(removed);
		return removed;
		
	}
	
	/**
	 * Returns the annotation threads in the document.
	 * @return the threads.
	 */
	public List<AnnotationThread> threads() {	
		
		List<AnnotationThread> threads = new LinkedList<AnnotationThread>();
		
		//pre-processing step:
		//separate annotations that start threads from those that follow
		List<GCubeAnnotation> answers = new LinkedList<GCubeAnnotation>();
		List<GCubeAnnotation> roots = new LinkedList<GCubeAnnotation>();
		
		for (GCubeAnnotation a : this)
			if (a.previousID()==null)
				roots.add(a);
			else
				answers.add(a);
		
		while (!roots.isEmpty())
			threads.add(thread(roots.remove(0),answers));
		
		return threads;
	} 
	
	//recursive, per-thread helper
	private AnnotationThread thread(GCubeAnnotation a, List<GCubeAnnotation> unthreaded) {
		
		//isolated new node
		if (a.id()==null)
			return new AnnotationThread(a);
			
		List<AnnotationThread> answers = new ArrayList<AnnotationThread>();
		
		//look for answers to annotations
		for (GCubeAnnotation other : new ArrayList<GCubeAnnotation>(unthreaded)) 
			if (a.id().equals(other.previousID())) {
				//recurse on answers using remaining unthreaded
				unthreaded.remove(other);
				answers.add(thread(other,unthreaded));
			}
		
		return new AnnotationThread(a,answers);
		
	}

}
