package org.gcube.data.access.ckanconnector;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;

import org.gcube.common.security.Owner;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.gcat.client.User;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import lombok.extern.slf4j.Slf4j;

@Path("/")
@Slf4j
public class ConnectorManager {

	@Context ServletContext context;

	RandomString randomString = new RandomString(12);


	@Path("disconnect")
	@GET
	public Response disconnect(@Context HttpServletRequest req) {
		log.info("disconnect called ");
		String hostname = context.getInitParameter("hostname");
		try{
			boolean found = false;
			if (req.getCookies()!=null)
				for (Cookie cookie : req.getCookies())
					if (cookie.getName().equals("auth_tkt")){ 
						found=true;
						break;
					}
			if (found)
				return Response.ok(context.getClassLoader().getResourceAsStream("logout.html"))
						.header(
								"Set-Cookie",
									"auth_tkt=deleted;Domain=%s;Path=/;Expires=Thu, 01-Jan-1970 00:00:01 GMT".formatted(hostname)
								)
								.header("Set-Cookie",
					"ckan_hide_header=deleted;Domain=%s;Path=/;Expires=Thu, 01-Jan-1970 00:00:01 GMT".formatted(hostname)
										).build();
			else return Response.ok(context.getClassLoader().getResourceAsStream("inactivesession.html")).build();

		}catch(Exception e){
			log.error("error disconnecting ",e);
			return Response.serverError().build();
		}
	}

	@Path("connect{pathInfo:(/[^?$]+)?}")
	@GET
	public Response connect(@PathParam(value = "pathInfo") String path, @Context HttpServletRequest req, @QueryParam(value="listOfVres") String vres ) {
		try{
			
//			This is done by smartgears
//			if (AuthorizationProvider.instance.get()==null || AuthorizationProvider.instance.get().getClient() == null ) return Response.status(Status.UNAUTHORIZED).build();
			
			log.info("passed path is {}",path);
			String ckanKey = context.getInitParameter("ckanKey");
			Secret secret = SecretManagerProvider.get();
			Owner owner = secret.getOwner();
			String originalUserName = owner.getId();

			String changedUserName =  originalUserName.replace(".", "_");
			
			// By invoking this API, gcat creates the user and add to the organization
			User user = new User();
			user.read(changedUserName);
			
			String context = secret.getContext();

			log.info("logging {} in scope {}",originalUserName, context);
			return createResponse(changedUserName, path, req.getQueryString());	
		}catch(Exception e){
			log.info("error trying to connect to CKAN",e);
			return Response.serverError().entity(e.getMessage()).build();
		}
	}


	private Response createResponse(String userName, String path, String query){
		try{
			String secret = context.getInitParameter("secret");
			String hostIp = context.getInitParameter("hostIp");
			String hostname = context.getInitParameter("hostname");
			String fixedData = "userid_type:unicode";
			long cookieCreateStart = System.currentTimeMillis();
			PythonInterpreter interpreter = new PythonInterpreter();
			interpreter.execfile(new FileInputStream(new File(this.getClass().getClassLoader().getResource("digest.py").getFile())));
			PyObject someFunc = interpreter.get("calculate_digest");
			long currentMillis = System.currentTimeMillis()/1000;
			PyObject ret = someFunc.__call__(new PyObject[]{new PyString(hostIp), new PyLong(currentMillis), new PyString(secret), 
					new PyString(userName), new PyString(""), new PyString(fixedData)} );
			String realResult = (String) ret.__tojava__(String.class);

			String timestamp16 = Long.toString(currentMillis, 16);
			
			String cookieValue = realResult+timestamp16+userName+"!"+fixedData;
			NewCookie cookie = new NewCookie("auth_tkt", 
					cookieValue,
					"/", hostname, "", -1, false, true );


			NewCookie cookieHideHeader = new NewCookie("ckan_hide_header", "true",
					"/", hostname, "", -1, false, true );

			log.info("create cookie took {}",(System.currentTimeMillis()-cookieCreateStart));
			log.info("old query string is {} ", query);
			
			String newQueryString = query.replaceFirst("&?gcube-token=[^&$]*&?", "").replaceFirst("&?listOfVres=[^&$]*&?", "");
			String baseUrl = "https://"+hostname;
			if (path!=null && !path.isEmpty())
				baseUrl+=path.startsWith("/")?path:"/"+path;  

			if (newQueryString!=null && !newQueryString.isEmpty())
				baseUrl+="?"+newQueryString;

			log.info("redirecting to {} ",baseUrl);

			return Response.seeOther(new URI(baseUrl))
					.cookie(cookie).cookie(cookieHideHeader).build();
		}catch(Exception e){
			log.error("Error while creating the Response", e);
			return Response.serverError().build();
		}
	}

}
