package org.gcube.data.access.ckanconnector;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;

import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.gcat.client.User;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;

import lombok.extern.slf4j.Slf4j;

@Path("/")
@Slf4j
public class ConnectorManager {

	@Context ServletContext context;

	RandomString randomString = new RandomString(12);


	@Path("disconnect")
	@GET
	public Response disconnect(@Context HttpServletRequest req) {
		log.info("disconnect called ");
		String hostname = context.getInitParameter("hostname");
		try{
			boolean found = false;
			if (req.getCookies()!=null)
				for (Cookie cookie : req.getCookies())
					if (cookie.getName().equals("auth_tkt")){ 
						found=true;
						break;
					}
			if (found)
				return Response.ok(context.getClassLoader().getResourceAsStream("logout.html"))
						.header(
								"Set-Cookie",
								String.format("auth_tkt=deleted;Domain=%s;Path=/;Expires=Thu, 01-Jan-1970 00:00:01 GMT",hostname)
								)
								.header("Set-Cookie",
										String.format("ckan_hide_header=deleted;Domain=%s;Path=/;Expires=Thu, 01-Jan-1970 00:00:01 GMT",hostname)
										).build();
			else return Response.ok(context.getClassLoader().getResourceAsStream("inactivesession.html")).build();

		}catch(Exception e){
			log.error("error disconnecting ",e);
			return Response.serverError().build();
		}
	}

	@Path("connect{pathInfo:(/[^?$]+)?}")
	@GET
	public Response connect(@PathParam(value = "pathInfo") String path, @Context HttpServletRequest req, @QueryParam(value="listOfVres") String vres ) {
		try{
			
			String originalUserName = AuthorizationProvider.instance.get().getClient().getId();
			String changedUserName =  originalUserName.replace(".", "_");
			
			// By invoking this API, gcat creates the user and add to the organization
			User user = new User();
			user.read(changedUserName);
			
			log.info("logging {} in scope {}",originalUserName, ScopeProvider.instance.get());
			return createResponse(changedUserName, path, req.getQueryString());	
		}catch(Exception e){
			log.info("error trying to connect to CKAN",e);
			return Response.serverError().entity(e.getMessage()).build();
		}
	}


	private Response createResponse(String userName, String path, String query){
		try{
			String secret = context.getInitParameter("secret");
			String hostIp = context.getInitParameter("hostIp");
			String hostname = context.getInitParameter("hostname");
			String fixedData = "userid_type:unicode";
			long cookieCreateStart = System.currentTimeMillis();
			PythonInterpreter interpreter = new PythonInterpreter();
			interpreter.execfile(new FileInputStream(new File(this.getClass().getClassLoader().getResource("digest.py").getFile())));
			PyObject someFunc = interpreter.get("calculate_digest");
			long currentMillis = System.currentTimeMillis()/1000;
			PyObject ret = someFunc.__call__(new PyObject[]{new PyString(hostIp), new PyLong(currentMillis), new PyString(secret), 
					new PyString(userName), new PyString(""), new PyString(fixedData)} );
			String realResult = (String) ret.__tojava__(String.class);

			String timestamp16 = Long.toString(currentMillis, 16);
			
			String cookieValue = realResult+timestamp16+userName+"!"+fixedData;
			NewCookie cookie = new NewCookie("auth_tkt", 
					cookieValue,
					"/", hostname, "", -1, false, true );


			NewCookie cookieHideHeader = new NewCookie("ckan_hide_header", "true",
					"/", hostname, "", -1, false, true );

			log.info("create cookie took {}",(System.currentTimeMillis()-cookieCreateStart));
			log.info("old query string is {} ", query);
			
			String newQueryString = query.replaceFirst("&?gcube-token=[^&$]*&?", "").replaceFirst("&?listOfVres=[^&$]*&?", "");
			String baseUrl = "https://"+hostname;
			if (path!=null && !path.isEmpty())
				baseUrl+=path.startsWith("/")?path:"/"+path;  

			if (newQueryString!=null && !newQueryString.isEmpty())
				baseUrl+="?"+newQueryString;

			log.info("redirecting to {} ",baseUrl);

			return Response.seeOther(new URI(baseUrl))
					.cookie(cookie).cookie(cookieHideHeader).build();
		}catch(Exception e){
			log.error("Error while creating the Response", e);
			return Response.serverError().build();
		}
	}

}
