/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.ckanconnector;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.access.ckanconnector.RandomString;
import org.gcube.gcat.client.User;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class ConnectorManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectorManager.class);
    @Context
    ServletContext context;
    RandomString randomString = new RandomString(12);

    @Path(value="disconnect")
    @GET
    public Response disconnect(@Context HttpServletRequest req) {
        log.info("disconnect called ");
        String hostname = this.context.getInitParameter("hostname");
        try {
            boolean found = false;
            if (req.getCookies() != null) {
                for (Cookie cookie : req.getCookies()) {
                    if (!cookie.getName().equals("auth_tkt")) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                return Response.ok((Object)this.context.getClassLoader().getResourceAsStream("logout.html")).header("Set-Cookie", (Object)String.format("auth_tkt=deleted;Domain=%s;Path=/;Expires=Thu, 01-Jan-1970 00:00:01 GMT", hostname)).header("Set-Cookie", (Object)String.format("ckan_hide_header=deleted;Domain=%s;Path=/;Expires=Thu, 01-Jan-1970 00:00:01 GMT", hostname)).build();
            }
            return Response.ok((Object)this.context.getClassLoader().getResourceAsStream("inactivesession.html")).build();
        }
        catch (Exception e) {
            log.error("error disconnecting ", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="connect{pathInfo:(/[^?$]+)?}")
    @GET
    public Response connect(@PathParam(value="pathInfo") String path, @Context HttpServletRequest req, @QueryParam(value="listOfVres") String vres) {
        try {
            log.info("passed path is {}", (Object)path);
            String ckanKey = this.context.getInitParameter("ckanKey");
            String originalUserName = AuthorizationProvider.instance.get().getClient().getId();
            String changedUserName = originalUserName.replace(".", "_");
            User user = new User();
            user.read(changedUserName);
            int internalPort = Integer.parseInt(this.context.getInitParameter("internalPort"));
            String localhostName = "http://127.0.0.1:" + internalPort;
            long startCheckUser = System.currentTimeMillis();
            log.info("logging {} in scope {}", (Object)originalUserName, (Object)ScopeProvider.instance.get());
            return this.createResponse(changedUserName, path, req.getQueryString());
        }
        catch (Exception e) {
            log.info("error trying to connect to CKAN", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private Response createResponse(String userName, String path, String query) {
        try {
            String secret = this.context.getInitParameter("secret");
            String hostIp = this.context.getInitParameter("hostIp");
            String hostname = this.context.getInitParameter("hostname");
            String fixedData = "userid_type:unicode";
            long cookieCreateStart = System.currentTimeMillis();
            PythonInterpreter interpreter = new PythonInterpreter();
            interpreter.execfile((InputStream)new FileInputStream(new File(this.getClass().getClassLoader().getResource("digest.py").getFile())));
            PyObject someFunc = interpreter.get("calculate_digest");
            long currentMillis = System.currentTimeMillis() / 1000L;
            PyObject ret = someFunc.__call__(new PyObject[]{new PyString(hostIp), new PyLong(currentMillis), new PyString(secret), new PyString(userName), new PyString(""), new PyString(fixedData)});
            String realResult = (String)ret.__tojava__(String.class);
            String timestamp16 = Long.toString(currentMillis, 16);
            String cookieValue = realResult + timestamp16 + userName + "!" + fixedData;
            NewCookie cookie = new NewCookie("auth_tkt", cookieValue, "/", hostname, "", -1, false, true);
            NewCookie cookieHideHeader = new NewCookie("ckan_hide_header", "true", "/", hostname, "", -1, false, true);
            log.info("create cookie took {}", (Object)(System.currentTimeMillis() - cookieCreateStart));
            log.info("old query string is {} ", (Object)query);
            String newQueryString = query.replaceFirst("&?gcube-token=[^&$]*&?", "").replaceFirst("&?listOfVres=[^&$]*&?", "");
            String baseUrl = "https://" + hostname;
            if (path != null && !path.isEmpty()) {
                baseUrl = baseUrl + (path.startsWith("/") ? path : "/" + path);
            }
            if (newQueryString != null && !newQueryString.isEmpty()) {
                baseUrl = baseUrl + "?" + newQueryString;
            }
            log.info("redirecting to {} ", (Object)baseUrl);
            return Response.seeOther((URI)new URI(baseUrl)).cookie(new NewCookie[]{cookie}).cookie(new NewCookie[]{cookieHideHeader}).build();
        }
        catch (Exception e) {
            log.error("Error while creating the Response", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

