/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.ckanconnector;

import com.google.gson.Gson;
import eu.trentorise.opendata.jackan.CkanClient;
import eu.trentorise.opendata.jackan.exceptions.CkanNotFoundException;
import eu.trentorise.opendata.jackan.model.CkanOrganization;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="organization")
public class OrganizationManager {
    private static final Logger log = LoggerFactory.getLogger(OrganizationManager.class);
    @Context
    ServletContext context;

    @PUT
    @Path(value="/{name}")
    public Response create(@PathParam(value="name") String organizationName) {
        log.info("create called");
        try {
            if (AuthorizationProvider.instance.get() == null || AuthorizationProvider.instance.get().getClient() == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            String ckanKey = this.context.getInitParameter("ckanKey");
            int internalPort = Integer.parseInt(this.context.getInitParameter("internalPort"));
            CkanClient ckanClient = new CkanClient("http://127.0.0.1:" + internalPort, ckanKey);
            CkanOrganization org = new CkanOrganization(organizationName.replaceAll(" ", "_").replace(".", "_").toLowerCase());
            org.setDisplayName(organizationName);
            org.setTitle(organizationName);
            ckanClient.createOrganization(org);
            log.info("create organizzation {} called from user {} in scope {}", new Object[]{organizationName, AuthorizationProvider.instance.get().getClient().getId(), ScopeProvider.instance.get()});
            return Response.ok().build();
        }
        catch (Exception e) {
            log.error("error trying to create organization " + organizationName, (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    public String get(@PathParam(value="name") String organizationName) {
        log.info("get called with name {}", (Object)organizationName);
        if (AuthorizationProvider.instance.get() == null || AuthorizationProvider.instance.get().getClient() == null) {
            throw new WebApplicationException("user authentication needed", Response.Status.UNAUTHORIZED);
        }
        String ckanKey = this.context.getInitParameter("ckanKey");
        int internalPort = Integer.parseInt(this.context.getInitParameter("internalPort"));
        try {
            CkanClient ckanClient = new CkanClient("http://127.0.0.1:" + internalPort, ckanKey);
            CkanOrganization org = ckanClient.getOrganization(organizationName.replaceAll(" ", "_").replace(".", "_").toLowerCase());
            log.trace("organization {} found", (Object)organizationName);
            return new Gson().toJson((Object)org);
        }
        catch (CkanNotFoundException e) {
            log.error("organization {} doesn't exist", (Object)organizationName);
            throw new WebApplicationException("organization " + organizationName + " doesn't exist", Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            log.error("error trying to contect ckan", (Throwable)e);
            throw new WebApplicationException("error trying to contect ckan", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

