/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.threem;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.data.access.threem.LoginNotExistsException;
import org.gcube.data.access.threem.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
public class Resource {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    @Context
    ServletContext context;

    @Path(value="connect")
    @GET
    public Response connect(@Context HttpServletRequest request, @Context HttpServletRequest response) {
        try {
            Response toReturn;
            try {
                toReturn = this._connect();
            }
            catch (LoginNotExistsException lne) {
                log.warn("user is not registered");
                log.info("trying to register the user");
                this.registerUser();
                log.info("user registered, trying to connect");
                toReturn = this._connect();
            }
            return toReturn;
        }
        catch (Throwable e) {
            log.error("error trying to connect", e);
            return Response.serverError().build();
        }
    }

    private Response _connect() throws LoginNotExistsException {
        Caller caller = AuthorizationProvider.instance.get();
        String commonPwd = this.getGeneratadePassword();
        String loginurl = this.context.getInitParameter("loginurl");
        String setCookies = "";
        String location = "";
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(loginurl);
        postMethod.setParameter("username", caller.getClient().getId());
        postMethod.setParameter("password", commonPwd);
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
        }
        catch (Exception e) {
            log.error("error trying to login", (Throwable)e);
        }
        if (postMethod.getStatusCode() != 302) {
            log.error("error logging in");
            throw new RuntimeException("error logging in");
        }
        location = postMethod.getResponseHeader("Location").getValue();
        setCookies = postMethod.getResponseHeader("Set-Cookie").getValue();
        log.info("with location {} and cookies {} ", (Object)location, (Object)setCookies);
        if (location.endsWith("Login?error=1")) {
            throw new LoginNotExistsException();
        }
        String[] cookies = setCookies.split(",", 2);
        ArrayList<NewCookie> newCookies = new ArrayList<NewCookie>();
        for (String cookie : cookies) {
            String pathValue;
            String[] singleValues = cookie.split(";");
            String[] nameAndValue = singleValues[0].split("=");
            if (nameAndValue[0].trim().equals("JSESSIONID")) {
                pathValue = singleValues[1].split("=")[1].trim();
                newCookies.add(new NewCookie(nameAndValue[0].trim(), nameAndValue[1].trim(), pathValue, null, null, -1, false));
                continue;
            }
            pathValue = singleValues[2].split("=")[1].trim();
            newCookies.add(new NewCookie(nameAndValue[0].trim(), nameAndValue[1].trim(), pathValue, null, null, 1080, false));
        }
        try {
            return Response.seeOther((URI)new URI(location)).cookie(newCookies.toArray(new NewCookie[newCookies.size()])).build();
        }
        catch (Exception e) {
            log.error("error trying to login", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private void registerUser() {
        String signUpUlr = this.context.getInitParameter("signUpulr");
        User user = this.retrieveUserInfo();
        log.trace("trying to register user {}", (Object)user.toString());
        String login = AuthorizationProvider.instance.get().getClient().getId();
        String commonPwd = this.getGeneratadePassword();
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(signUpUlr);
        postMethod.setParameter("username", login);
        postMethod.setParameter("password", commonPwd);
        postMethod.setParameter("passwordV", commonPwd);
        postMethod.setParameter("lastname", user.getLastName());
        postMethod.setParameter("firstname", user.getFirstName());
        postMethod.setParameter("email", user.getEmail());
        postMethod.setParameter("address", "");
        postMethod.setParameter("lang", "en");
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
            log.trace("returned on registratoin: {} ", (Object)postMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            log.error("error trying to login using url {}", (Object)signUpUlr, (Object)e);
        }
        if (postMethod.getStatusCode() == 400 || postMethod.getStatusCode() == 500) {
            log.error("error logging in");
            throw new RuntimeException("error registering user " + login + " to 3M service");
        }
    }

    private User retrieveUserInfo() {
        String socialServiceEnpoint = this.context.getInitParameter("socialServiceEnpoint");
        String name = "";
        String lastName = "unknown";
        String email = "";
        ObjectMapper mapper = new ObjectMapper();
        HttpClient httpClient = new HttpClient();
        GetMethod getProfile = new GetMethod(socialServiceEnpoint + "?gcube-token=" + SecurityTokenProvider.instance.get());
        try {
            httpClient.executeMethod((HttpMethod)getProfile);
            String profile = getProfile.getResponseBodyAsString();
            Map map = new HashMap();
            map = (Map)mapper.readValue(profile, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Map profileMap = (Map)map.get("result");
            name = (String)profileMap.get("first_name");
            if (profileMap.get("last_name") != null && !((String)profileMap.get("last_name")).isEmpty()) {
                lastName = (String)profileMap.get("last_name");
            }
            email = (String)profileMap.get("email");
            log.trace("found profile {}, {}, {}", new Object[]{name, lastName, email});
            return new User(name, lastName, email);
        }
        catch (Exception e) {
            throw new RuntimeException("error getting profile from social service", e);
        }
    }

    private String getGeneratadePassword() {
        return "gcube!3M!" + AuthorizationProvider.instance.get().getClient().getId().hashCode();
    }
}

