/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.gcube.datatransformation.client.library.beans.Types;
import org.gcube.datatransformation.client.library.exceptions.DTSClientException;
import org.gcube.datatransformation.client.library.exceptions.DTSException;
import org.gcube.datatransformation.rest.commons.DataTransformationDiscoverer;
import org.gcube.datatransformation.rest.commons.DataTransformationDiscovererAPI;
import org.gcube.datatransformation.rest.commons.DataTransformationServiceAPI;
import org.gcube.rest.resourcemanager.discoverer.ri.RunningInstancesDiscoverer;
import org.gcube.rest.resourcemanager.is.discoverer.ri.icclient.RIDiscovererISimpl;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransformationClient {
    private static final Logger logger = LoggerFactory.getLogger(DataTransformationClient.class);
    private Gson gson = new Gson();
    private String scope;
    private String endpoint;
    private DataTransformationDiscovererAPI dataTransformationDiscoverer = new DataTransformationDiscoverer((RunningInstancesDiscoverer)new RIDiscovererISimpl("DataTransformationService", "DataTransformation", "resteasy-servlet", this.scope));

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void initializeClient(String endpoint) {
        this.endpoint = endpoint;
    }

    public void randomClient() throws DTSClientException {
        Random random = new Random();
        Set ris = this.dataTransformationDiscoverer.discoverDataTransformationRunninInstances(this.scope);
        if (ris == null || ris.size() == 0) {
            throw new DTSClientException("No data transformation endopoints found");
        }
        ArrayList dataTransformationServices = new ArrayList(ris);
        this.endpoint = (String)dataTransformationServices.get(random.nextInt(dataTransformationServices.size()));
    }

    public String statistics() throws DTSException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        DataTransformationServiceAPI simple = null;
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(this.endpoint);
            simple = (DataTransformationServiceAPI)target.proxy(DataTransformationServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint: " + this.endpoint, (Throwable)e);
            throw new DTSException("Client could not connect to endpoint: " + this.endpoint, e);
        }
        Response response = null;
        response = simple.statistics(this.scope);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String xml = (String)response.readEntity(String.class);
        response.close();
        return xml;
    }

    public Types.TransformDataResponse transformData(Types.TransformData request) throws DTSException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        DataTransformationServiceAPI simple = null;
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(this.endpoint);
            simple = (DataTransformationServiceAPI)target.proxy(DataTransformationServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint: " + this.endpoint, (Throwable)e);
            throw new DTSException("Client could not connect to endpoint: " + this.endpoint, e);
        }
        Response response = null;
        response = simple.transformData(this.scope, this.gson.toJson((Object)request.input), this.gson.toJson((Object)request.targetContentType), this.gson.toJson((Object)request.output), request.createReport.toString(), Boolean.valueOf(false), Boolean.valueOf(true));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        System.out.println(json);
        return (Types.TransformDataResponse)this.gson.fromJson(json, Types.TransformDataResponse.class);
    }

    public Types.TransformDataWithTransformationProgramResponse transformDataWithTransformationProgram(Types.TransformDataWithTransformationProgram request) throws DTSException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        DataTransformationServiceAPI simple = null;
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(this.endpoint);
            simple = (DataTransformationServiceAPI)target.proxy(DataTransformationServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint: " + this.endpoint, (Throwable)e);
            throw new DTSException("Client could not connect to endpoint: " + this.endpoint, e);
        }
        Response response = null;
        response = simple.transformDataWithTransformationProgram(this.scope, this.gson.toJson((Object)request.input), this.gson.toJson((Object)request.tpID), this.gson.toJson((Object)request.targetContentType), this.gson.toJson(request.tProgramUnboundParameters), this.gson.toJson((Object)request.output), request.createReport.toString(), Boolean.valueOf(false), Boolean.valueOf(true));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        System.out.println(json);
        return (Types.TransformDataWithTransformationProgramResponse)this.gson.fromJson(json, Types.TransformDataWithTransformationProgramResponse.class);
    }

    public Types.TransformDataWithTransformationUnitResponse transformDataWithTransformationUnit(Types.TransformDataWithTransformationUnit request) throws DTSException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        DataTransformationServiceAPI simple = null;
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(this.endpoint);
            simple = (DataTransformationServiceAPI)target.proxy(DataTransformationServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint: " + this.endpoint, (Throwable)e);
            throw new DTSException("Client could not connect to endpoint: " + this.endpoint, e);
        }
        Response response = null;
        response = simple.transformDataWithTransformationUnit(this.scope, this.gson.toJson(request.inputs), this.gson.toJson((Object)request.tpID), this.gson.toJson((Object)request.transformationUnitID), this.gson.toJson((Object)request.targetContentType), this.gson.toJson(request.tProgramUnboundParameters), this.gson.toJson((Object)request.output), request.filterSources.toString(), request.createReport.toString(), Boolean.valueOf(false), Boolean.valueOf(true));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        System.out.println(json);
        return (Types.TransformDataWithTransformationUnitResponse)this.gson.fromJson(json, Types.TransformDataWithTransformationUnitResponse.class);
    }

    public Types.FindApplicableTransformationUnitsResponse findApplicableTransformationUnits(Types.FindApplicableTransformationUnits request) throws DTSException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        DataTransformationServiceAPI simple = null;
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(this.endpoint);
            simple = (DataTransformationServiceAPI)target.proxy(DataTransformationServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint: " + this.endpoint, (Throwable)e);
            throw new DTSException("Client could not connect to endpoint: " + this.endpoint, e);
        }
        Response response = null;
        response = simple.findApplicableTransformationUnits(this.scope, this.gson.toJson((Object)request.sourceContentType), this.gson.toJson((Object)request.targetContentType), this.gson.toJson((Object)request.createAndPublishCompositeTP), Boolean.valueOf(true));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        System.out.println(json);
        return (Types.FindApplicableTransformationUnitsResponse)this.gson.fromJson(json, Types.FindApplicableTransformationUnitsResponse.class);
    }

    public Types.FindAvailableTargetContentTypesResponse findAvailableTargetContent(Types.FindAvailableTargetContentTypes request) throws DTSException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        DataTransformationServiceAPI simple = null;
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(this.endpoint);
            simple = (DataTransformationServiceAPI)target.proxy(DataTransformationServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint: " + this.endpoint, (Throwable)e);
            throw new DTSException("Client could not connect to endpoint: " + this.endpoint, e);
        }
        Response response = null;
        response = simple.findAvailableTargetContentTypes(this.scope, this.gson.toJson((Object)request.sourceContentType), Boolean.valueOf(true));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        System.out.println(json);
        return (Types.FindAvailableTargetContentTypesResponse)this.gson.fromJson(json, Types.FindAvailableTargetContentTypesResponse.class);
    }

    public Types.QueryTransformationProgramsResponse queryTransformationPrograms(Types.QueryTransformationPrograms request) throws DTSException {
        ResteasyClient client = null;
        ResteasyWebTarget target = null;
        DataTransformationServiceAPI simple = null;
        try {
            client = new ResteasyClientBuilder().build();
            target = client.target(this.endpoint);
            simple = (DataTransformationServiceAPI)target.proxy(DataTransformationServiceAPI.class);
        }
        catch (Exception e) {
            logger.error("Client could not connect to endpoint: " + this.endpoint, (Throwable)e);
            throw new DTSException("Client could not connect to endpoint: " + this.endpoint, e);
        }
        Response response = null;
        response = simple.queryTransformationPrograms(this.scope, request.queryTransformationPrograms, Boolean.valueOf(true));
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            String error = (String)response.readEntity(String.class);
            response.close();
            logger.error("response error: " + error);
            throw new DTSException("response error: " + error);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        System.out.println(json);
        Types.QueryTransformationProgramsResponse queryTransformationProgramsResponse = new Types.QueryTransformationProgramsResponse();
        queryTransformationProgramsResponse.queryTransformationProgramsResponse = json;
        return queryTransformationProgramsResponse;
    }
}

