/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLIUtils {
    private static Logger log = LoggerFactory.getLogger(CLIUtils.class);

    public static int executeCommand(String command) throws Exception {
        log.debug("Going to execute command: " + command);
        try {
            final Process process = Runtime.getRuntime().exec(command);
            new Thread(){

                @Override
                public void run() {
                    try {
                        InputStream is = process.getInputStream();
                        BufferedReader bufIn = new BufferedReader(new InputStreamReader(is));
                        String line = null;
                        while ((line = bufIn.readLine()) != null) {
                            log.debug(line);
                        }
                        bufIn.close();
                    }
                    catch (Exception e) {
                        log.error("Exception in reading stdin of cli command", (Throwable)e);
                    }
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    try {
                        InputStream is = process.getErrorStream();
                        BufferedReader bufIn = new BufferedReader(new InputStreamReader(is));
                        String line = null;
                        while ((line = bufIn.readLine()) != null) {
                            log.debug(line);
                        }
                        bufIn.close();
                    }
                    catch (Exception e) {
                        log.error("Exception in reading stderr of cli command", (Throwable)e);
                    }
                }
            }.start();
            int returnCode = process.waitFor();
            if (returnCode != 0) {
                log.warn("CL program execution failed with return code: " + returnCode);
            } else {
                log.debug("CL program execution succeded.");
            }
            return returnCode;
        }
        catch (Exception e) {
            log.error("Exception in executing cli command: " + command, (Throwable)e);
            throw new Exception("Exception in executing cli command: " + command, e);
        }
    }
}

