/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.security;

import java.util.HashMap;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.IManager;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.ISManager;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TransformationsGraph;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TransformationsGraphImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTSSManager {
    private static Logger log = LoggerFactory.getLogger(DTSSManager.class);
    protected static volatile HashMap<String, DTSCore> dCoreMap = new HashMap();

    public static DTSCore getDTSCore(String scope) throws Exception {
        if (scope == null) {
            log.error("Scope not specified");
            throw new Exception("Scope not specified");
        }
        DTSCore dCore = (DTSCore)dCoreMap.get(scope);
        if (dCore == null) {
            log.error("DTS is not deployed in scope " + scope);
            throw new Exception("DTS is not deployed in scope " + scope);
        }
        return dCore;
    }

    public static void init(String[] addedScopes) throws Exception {
        log.debug("DTSSManager is initialized...");
        log.debug("Scopes were added...");
        if (addedScopes != null && addedScopes.length > 0) {
            for (String scope : addedScopes) {
                if (dCoreMap.get(scope) != null) {
                    log.warn("Instance for scope " + scope + " already exist");
                    continue;
                }
                try {
                    log.debug("Going to create dCore instance for scope " + scope);
                    ISManager imanager = new ISManager();
                    imanager.setScope(scope.toString());
                    TransformationsGraphImpl graph = new TransformationsGraphImpl((IManager)imanager);
                    DTSCore dcore = new DTSCore((IManager)imanager, (TransformationsGraph)graph);
                    dCoreMap.put(scope, dcore);
                }
                catch (Exception e) {
                    log.error("Could not create DTSCore Instance for scope " + scope, (Throwable)e);
                }
            }
        } else {
            log.warn("No scope to add");
        }
    }
}

