/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GRS2ExceptionWrapper;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.gcube.datatransformation.DataTransformationService;
import org.gcube.datatransformation.ServiceContext;
import org.gcube.datatransformation.client.library.exceptions.DTSException;
import org.gcube.datatransformation.client.library.exceptions.EmptySourceException;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.IOHandler;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Input;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Output;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.gcube.datatransformation.datatransformationlibrary.statistics.StatisticsManager;
import org.gcube.datatransformation.datatransformationlibrary.transformation.model.TransformationDescription;
import org.gcube.datatransformation.datatransformationlibrary.utils.JSONConverter;
import org.gcube.datatransformation.rest.commons.DataTransformationServiceAPI;
import org.jboss.resteasy.annotations.GZIP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/")
public class DataTransformationService
implements DataTransformationServiceAPI {
    public static final String SCOPE_HEADER = "gcube-scope";
    boolean initialized = false;
    private Gson gson = new Gson();
    private static final Logger logger = LoggerFactory.getLogger(DataTransformationService.class);
    private boolean isLocal = false;

    public DataTransformationService() throws Exception {
        this.initialize();
    }

    synchronized void initialize() throws Exception {
        if (!this.initialized) {
            System.out.println("Initializing Data Transformation Service...");
            ServiceContext sc = new ServiceContext();
            this.isLocal = sc.isLocal();
            System.out.println("Initializing Data Transformation Service...OK");
            this.initialized = true;
        }
    }

    private static String buildExceptionResponseString(Exception e) {
        JsonObject result = new JsonObject();
        result.add("exception", (JsonElement)new JsonPrimitive(DataTransformationService.toString((Serializable)e)));
        return JSONConverter.toJSON((Object)result);
    }

    private static String toString(Serializable o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            return new String(Base64.encodeBase64((byte[])baos.toByteArray()));
        }
        catch (IOException e) {
            return null;
        }
    }

    @GET
    @Path(value="/statistics")
    @Produces(value={"application/xml; charset=UTF-8"})
    @GZIP
    public Response statistics(@HeaderParam(value="gcube-scope") String scope) {
        String xml = StatisticsManager.toXML();
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).entity((Object)xml).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/transformData")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response transformData(@HeaderParam(value="gcube-scope") String scope, @FormParam(value="input") String inputJSON, @FormParam(value="targetContentType") String targetContentTypeJSON, @FormParam(value="output") String outputJSON, @FormParam(value="createReport") String createReportJSON, @QueryParam(value="all") @DefaultValue(value="false") Boolean all, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty) {
        DataSource source;
        Input input;
        Output output;
        ContentType targetContentType;
        long starttime = System.currentTimeMillis();
        String[] strs = new String[]{inputJSON, targetContentTypeJSON, outputJSON, createReportJSON};
        logger.debug(Arrays.asList(strs).toString());
        Boolean createReport = null;
        try {
            try {
                targetContentType = (ContentType)this.gson.fromJson(targetContentTypeJSON, ContentType.class);
            }
            catch (Exception e) {
                throw new Exception("Target content type not set properly: " + targetContentTypeJSON, e);
            }
            try {
                createReport = (Boolean)this.gson.fromJson(createReportJSON, Boolean.class);
                ReportManager.initializeReport((boolean)createReport);
            }
            catch (Exception e) {
                logger.warn("Could not create report but continuing with the transformation...", (Throwable)e);
            }
            try {
                output = (Output)this.gson.fromJson(outputJSON, Output.class);
            }
            catch (Exception e) {
                throw new Exception("Output not set properly: " + outputJSON, e);
            }
            try {
                input = (Input)this.gson.fromJson(inputJSON, Input.class);
                source = IOHandler.getDataSource((Input)input);
            }
            catch (Exception e) {
                throw new Exception("Could not create DataSource from the given Input: " + inputJSON, e);
            }
        }
        catch (Exception e) {
            logger.error("error while reading request", (Throwable)e);
            this.releaseResources();
            String msg = JSONConverter.toJSON((String)"msg", (Object)e.getMessage());
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        logger.trace("input: " + input + ", " + "targetContentType: " + targetContentType + ", " + "output: " + output + ", " + "createReport: " + createReport);
        TransformationDescription tDesc = new TransformationDescription(input, output);
        DTSCore dCore = null;
        try {
            dCore = DTSSManager.getDTSCore((String)scope);
            try {
                dCore.initializeAdaptor(tDesc, scope, this.isLocal);
            }
            catch (Exception e) {
                throw new Exception("Could not initialize workflow adaptor for the Data Transformation", e);
            }
            dCore.transformData(source, targetContentType);
            String retVal = tDesc.getReturnedValue();
            long endtime = System.currentTimeMillis();
            logger.info("Transformation submitted after : " + (endtime - starttime) + " ms. grs : " + retVal);
            Response response = this.buildResponse(retVal, pretty.booleanValue(), all.booleanValue(), output.getOutputType());
            return response;
        }
        catch (Exception e) {
            logger.error("error while submitting transformation: ", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            Response response = Response.status((Response.Status)status).entity((Object)msg).build();
            return response;
        }
        finally {
            dCore.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/transformDataWithTransformationProgram")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response transformDataWithTransformationProgram(@HeaderParam(value="gcube-scope") String scope, @FormParam(value="input") String inputJSON, @FormParam(value="tpID") String tpIDJSON, @FormParam(value="targetContentType") String targetContentTypeJSON, @FormParam(value="tProgramUnboundParameters") String tProgramUnboundParametersJSON, @FormParam(value="output") String outputJSON, @FormParam(value="createReport") String createReportJSON, @QueryParam(value="all") @DefaultValue(value="false") Boolean all, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty) {
        DataSource source;
        Input inputD;
        Output output;
        ContentType targetContentType;
        long starttime = System.currentTimeMillis();
        String[] strs = new String[]{inputJSON, tpIDJSON, targetContentTypeJSON, tProgramUnboundParametersJSON, outputJSON, createReportJSON};
        logger.debug(Arrays.asList(strs).toString());
        String transformationProgramID = null;
        Boolean createReport = null;
        Parameter[] programUnboundParameters = null;
        try {
            transformationProgramID = (String)this.gson.fromJson(tpIDJSON, String.class);
            if (transformationProgramID == null || transformationProgramID.trim().length() == 0) {
                throw new Exception("Transformation program ID not set");
            }
            try {
                targetContentType = (ContentType)this.gson.fromJson(targetContentTypeJSON, ContentType.class);
            }
            catch (Exception e) {
                throw new Exception("Target content type not set properly: " + targetContentTypeJSON, e);
            }
            try {
                programUnboundParameters = (Parameter[])this.gson.fromJson(tProgramUnboundParametersJSON, Parameter[].class);
            }
            catch (Exception e) {
                logger.warn("Undefined error when converting unbound parameters from stub to model parameter type", (Throwable)e);
            }
            try {
                createReport = (Boolean)this.gson.fromJson(createReportJSON, Boolean.class);
                ReportManager.initializeReport((boolean)createReport);
            }
            catch (Exception e) {
                logger.warn("Could not create report but continuing with the transformation...", (Throwable)e);
            }
            try {
                output = (Output)this.gson.fromJson(outputJSON, Output.class);
            }
            catch (Exception e) {
                throw new Exception("Output not set properly: " + outputJSON, e);
            }
            try {
                inputD = (Input)this.gson.fromJson(inputJSON, Input.class);
                source = IOHandler.getDataSource((Input)inputD);
            }
            catch (Exception e) {
                throw new Exception("Could not create DataSource from the given Input: " + inputJSON, e);
            }
        }
        catch (Exception e) {
            logger.error("error while reading request", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        logger.trace("input: " + inputD + ", " + "targetContentType: " + targetContentType + ", " + "output: " + output + ", " + "createReport: " + createReport);
        TransformationDescription tDesc = new TransformationDescription(inputD, output);
        DTSCore dCore = null;
        try {
            dCore = DTSSManager.getDTSCore((String)scope);
            try {
                dCore.initializeAdaptor(tDesc, scope, this.isLocal);
            }
            catch (Exception e) {
                throw new Exception("Could not initialize workflow adaptor for the Data Transformation", e);
            }
            dCore.transformDataWithTransformationProgram(source, transformationProgramID, programUnboundParameters, targetContentType);
            String retVal = tDesc.getReturnedValue();
            long endtime = System.currentTimeMillis();
            logger.info("Transformation submitted after : " + (endtime - starttime) + " ms. grs : " + retVal);
            Response response = this.buildResponse(retVal, pretty.booleanValue(), all.booleanValue(), output.getOutputType());
            return response;
        }
        catch (Exception e) {
            logger.error("error while submitting transformation: ", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            Response response = Response.status((Response.Status)status).entity((Object)msg).build();
            return response;
        }
        finally {
            dCore.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/transformDataWithTransformationUnit")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response transformDataWithTransformationUnit(@HeaderParam(value="gcube-scope") String scope, @FormParam(value="inputs") String inputsJSON, @FormParam(value="tpID") String tpIDJSON, @FormParam(value="transformationUnitID") String transformationUnitIDJSON, @FormParam(value="targetContentType") String targetContentTypeJSON, @FormParam(value="tProgramUnboundParameters") String tProgramUnboundParametersJSON, @FormParam(value="output") String outputJSON, @FormParam(value="filterSources") String filterSourcesJSON, @FormParam(value="createReport") String createReportJSON, @QueryParam(value="all") @DefaultValue(value="false") Boolean all, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty) {
        Input inputD;
        Output output;
        ContentType targetContentType;
        long starttime = System.currentTimeMillis();
        String[] strs = new String[]{inputsJSON, tpIDJSON, transformationUnitIDJSON, targetContentTypeJSON, tProgramUnboundParametersJSON, outputJSON, filterSourcesJSON, createReportJSON};
        logger.debug(Arrays.asList(strs).toString());
        String transformationProgramID = null;
        String transformationUnitID = null;
        Boolean filterSources = false;
        Boolean createReport = false;
        Parameter[] programUnboundParameters = null;
        try {
            transformationProgramID = (String)this.gson.fromJson(tpIDJSON, String.class);
            if (transformationProgramID == null || transformationProgramID.trim().length() == 0) {
                throw new Exception("Transformation program ID not set");
            }
            transformationUnitID = (String)this.gson.fromJson(transformationUnitIDJSON, String.class);
            if (transformationUnitID == null || transformationUnitID.trim().length() == 0) {
                throw new Exception("Transformation unit ID not set");
            }
            try {
                targetContentType = (ContentType)this.gson.fromJson(targetContentTypeJSON, ContentType.class);
            }
            catch (Exception e) {
                throw new Exception("Target content type not set properly: " + targetContentTypeJSON, e);
            }
            try {
                programUnboundParameters = (Parameter[])this.gson.fromJson(tProgramUnboundParametersJSON, Parameter[].class);
            }
            catch (Exception e) {
                logger.warn("Undefined error when converting unbound parameters from stub to model parameter type", (Throwable)e);
            }
            try {
                createReport = (Boolean)this.gson.fromJson(createReportJSON, Boolean.class);
                ReportManager.initializeReport((boolean)createReport);
            }
            catch (Exception e) {
                logger.warn("Could not create report but continuing with the transformation...", (Throwable)e);
            }
            try {
                filterSources = (Boolean)this.gson.fromJson(filterSourcesJSON, Boolean.class);
            }
            catch (Exception e) {
                logger.warn("Could not get filterSources value. set to false", (Throwable)e);
            }
            try {
                output = (Output)this.gson.fromJson(outputJSON, Output.class);
            }
            catch (Exception e) {
                throw new Exception("Output not set properly: " + outputJSON, e);
            }
            try {
                inputD = ((Input[])this.gson.fromJson(inputsJSON, Input[].class))[0];
            }
            catch (Exception e) {
                throw new Exception("Could not create DataSource from the given Input: " + inputsJSON, e);
            }
        }
        catch (Exception e) {
            logger.error("error while reading request", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        logger.trace("input: " + inputD + ", " + "targetContentType: " + targetContentType + ", " + "output: " + output + ", " + "createReport: " + createReport);
        TransformationDescription tDesc = new TransformationDescription(inputD, output);
        DTSCore dCore = null;
        try {
            dCore = DTSSManager.getDTSCore((String)scope);
            try {
                dCore.initializeAdaptor(tDesc, scope, this.isLocal);
            }
            catch (Exception e) {
                throw new Exception("Could not initialize workflow adaptor for the Data Transformation", e);
            }
            dCore.transformDataWithTransformationUnit(transformationProgramID, transformationUnitID, programUnboundParameters, targetContentType, filterSources.booleanValue());
            String retVal = tDesc.getReturnedValue();
            long endtime = System.currentTimeMillis();
            if (retVal == null) {
                throw new DTSException("Transformation error");
            }
            if (retVal.trim().isEmpty()) {
                throw new EmptySourceException("DataSource timeout after " + (endtime - starttime) + "ms");
            }
            logger.info("Transformation submitted after : " + (endtime - starttime) + " ms. grs : " + retVal);
            Response response = this.buildResponse(retVal, pretty.booleanValue(), all.booleanValue(), output.getOutputType());
            return response;
        }
        catch (Exception e) {
            logger.error("error while submitting transformation: ", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            Response response = Response.status((Response.Status)status).entity((Object)msg).build();
            return response;
        }
        finally {
            if (dCore != null) {
                dCore.clean();
            }
        }
    }

    @POST
    @Path(value="/findApplicableTransformationUnits")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response findApplicableTransformationUnits(@HeaderParam(value="gcube-scope") String scope, @FormParam(value="sourceContentType") String sourceContentTypeJSON, @FormParam(value="targetContentType") String targetContentTypeJSON, @FormParam(value="createAndPublishCompositeTP") String createAndPublishCompositeTPJSON, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty) {
        ContentType targetContentType;
        ContentType sourceContentType;
        long starttime = System.currentTimeMillis();
        String[] strs = new String[]{sourceContentTypeJSON, targetContentTypeJSON, createAndPublishCompositeTPJSON};
        logger.debug(Arrays.asList(strs).toString());
        Boolean createAndPublishCompositeTP = false;
        try {
            try {
                sourceContentType = (ContentType)this.gson.fromJson(sourceContentTypeJSON, ContentType.class);
            }
            catch (Exception e) {
                throw new Exception("Target content type not set properly: " + sourceContentTypeJSON, e);
            }
            try {
                targetContentType = (ContentType)this.gson.fromJson(targetContentTypeJSON, ContentType.class);
            }
            catch (Exception e) {
                throw new Exception("Target content type not set properly: " + targetContentTypeJSON, e);
            }
            try {
                createAndPublishCompositeTP = (Boolean)this.gson.fromJson(createAndPublishCompositeTPJSON, Boolean.class);
            }
            catch (Exception e) {
                logger.warn("Could not determine createAndPublishCompositeTP but continuing: " + createAndPublishCompositeTPJSON);
            }
        }
        catch (Exception e) {
            logger.error("error while reading request", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        logger.trace("sourceContentType: " + sourceContentType + ", " + "targetContentType: " + targetContentType + ", " + "createAndPublishCompositeTP: " + createAndPublishCompositeTP);
        try {
            DTSCore dCore = DTSSManager.getDTSCore((String)scope);
            ArrayList transformations = dCore.findApplicableTransformationUnits(sourceContentType, targetContentType, createAndPublishCompositeTP.booleanValue());
            ArrayList resp = new ArrayList();
            for (TransformationUnit transformation : transformations) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("transformationUnitID", transformation.getId());
                map.put("transformationProgramID", transformation.getTransformationProgram().getId());
                resp.add(map);
            }
            HashMap response = new HashMap();
            response.put("TPAndTransformationUnitIDs", resp);
            String msg = null;
            msg = JSONConverter.toJSON(response);
            logger.debug("Returning response: " + msg);
            long endtime = System.currentTimeMillis();
            logger.info("Transformation submitted after : " + (endtime - starttime) + " ms. grs : " + msg);
            Response.Status status = Response.Status.OK;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        catch (Exception e) {
            logger.error("error while submitting transformation: ", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
    }

    @POST
    @Path(value="/findAvailableTargetContentTypes")
    @Produces(value={"application/json; charset=UTF-8"})
    @GZIP
    public Response findAvailableTargetContentTypes(@HeaderParam(value="gcube-scope") String scope, @FormParam(value="sourceContentType") String sourceContentTypeJSON, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty) {
        ContentType sourceContentType;
        long starttime = System.currentTimeMillis();
        String[] strs = new String[]{sourceContentTypeJSON};
        logger.debug(Arrays.asList(strs).toString());
        try {
            try {
                sourceContentType = (ContentType)this.gson.fromJson(sourceContentTypeJSON, ContentType.class);
                if (sourceContentType == null) {
                    throw new Exception("source content type is null");
                }
            }
            catch (Exception e) {
                throw new Exception("Target content type not set properly: " + sourceContentTypeJSON, e);
            }
        }
        catch (Exception e) {
            logger.error("error while reading request", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        logger.trace("sourceContentType: " + sourceContentType);
        try {
            DTSCore dCore = DTSSManager.getDTSCore((String)scope);
            ArrayList targetContentTypes = dCore.getAvailableTargetContentTypes(sourceContentType);
            long endtime = System.currentTimeMillis();
            String msg = null;
            HashMap<String, ArrayList> response = new HashMap<String, ArrayList>();
            response.put("targetContentTypes", targetContentTypes);
            msg = JSONConverter.toJSON(response, (boolean)pretty);
            logger.info("Transformation submitted after : " + (endtime - starttime) + " ms. grs : " + msg);
            Response.Status status = Response.Status.OK;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        catch (Exception e) {
            logger.error("error while submitting transformation: ", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
    }

    @POST
    @Path(value="/queryTransformationPrograms")
    @Produces(value={"application/xml; charset=UTF-8"})
    @GZIP
    public Response queryTransformationPrograms(@HeaderParam(value="gcube-scope") String scope, @FormParam(value="query") String queryJSON, @QueryParam(value="pretty") @DefaultValue(value="false") Boolean pretty) {
        String query;
        long starttime = System.currentTimeMillis();
        String[] strs = new String[]{queryJSON};
        logger.debug(Arrays.asList(strs).toString());
        try {
            try {
                query = queryJSON;
                if (query == null || query.trim().length() == 0) {
                    throw new Exception("query is null");
                }
            }
            catch (Exception e) {
                throw new Exception("Could not query transfomration programs: " + queryJSON, e);
            }
        }
        catch (Exception e) {
            logger.error("error while reading request", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        logger.trace("query: " + queryJSON);
        try {
            DTSCore dCore = DTSSManager.getDTSCore((String)scope);
            String resp = dCore.getIManager().queryTransformationPrograms(query);
            long endtime = System.currentTimeMillis();
            logger.info("Transformation submitted after : " + (endtime - starttime) + " response: " + resp);
            String msg = null;
            msg = resp;
            Response.Status status = Response.Status.OK;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
        catch (Exception e) {
            logger.error("error while submitting transformation: ", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
    }

    private void releaseResources() {
        if (ReportManager.isReportingEnabled()) {
            try {
                ReportManager.closeReport();
            }
            catch (Exception e) {
                logger.error("Could not close report", (Throwable)e);
            }
        }
    }

    private Response buildResponse(String retVal, boolean pretty, boolean all, String outputType) {
        try {
            if (all && (outputType.equals("GRS2") || outputType.equals("RS2"))) {
                1 stream = new /* Unavailable Anonymous Inner Class!! */;
                return Response.ok((Object)stream).build();
            }
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("output", retVal);
            if (ReportManager.isReportingEnabled()) {
                try {
                    response.put("reportEPR", ReportManager.getReport().getReportEndpoint());
                    logger.debug("Report RS EPR: " + ReportManager.getReport().getReportEndpoint());
                }
                catch (Exception e) {
                    logger.warn("Could not get the RS EPR of the Report, but continuing nevertheless...", (Throwable)e);
                }
            }
            String msg = JSONConverter.toJSON(response, (boolean)pretty);
            return Response.ok().entity((Object)msg).build();
        }
        catch (Exception e) {
            logger.error("error while submitting transformation: ", (Throwable)e);
            this.releaseResources();
            String msg = DataTransformationService.buildExceptionResponseString((Exception)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)msg).build();
        }
    }

    static void readResults(BufferedWriter writer, String rsLocator, Boolean pretty) throws Exception {
        ForwardReader reader = new ForwardReader(URI.create(rsLocator));
        writer.write("[");
        if (pretty.booleanValue()) {
            writer.newLine();
        }
        boolean first = true;
        while (reader.getStatus() != IBuffer.Status.Dispose && (reader.getStatus() != IBuffer.Status.Close || reader.availableRecords() != 0)) {
            GenericRecord rec = (GenericRecord)reader.get(60L, TimeUnit.SECONDS);
            if (rec == null) continue;
            if (!first) {
                writer.write(",");
                if (pretty.booleanValue()) {
                    writer.newLine();
                }
            }
            if (rec instanceof GRS2ExceptionWrapper) {
                writer.write(DataTransformationService.buildExceptionResponseString((Exception)new Exception(((GRS2ExceptionWrapper)rec).getEx())));
                continue;
            }
            first = false;
            JsonObject jo = new JsonObject();
            for (Field field : rec.getFields()) {
                String fieldID = field.getFieldDefinition().getName();
                String fieldName = null;
                fieldName = fieldID;
                String fieldValue = null;
                if (field instanceof FileField) {
                    File f = ((FileField)field).getPayload();
                    fieldValue = Charset.defaultCharset().decode(ByteBuffer.wrap(Files.readAllBytes(Paths.get(f.getAbsolutePath(), new String[0])))).toString();
                } else if (field instanceof StringField) {
                    fieldValue = ((StringField)field).getPayload();
                }
                jo.add(fieldName, (JsonElement)new JsonPrimitive(fieldValue));
            }
            writer.write(JSONConverter.toJSON((Object)jo));
            writer.flush();
        }
        if (pretty.booleanValue()) {
            writer.newLine();
        }
        writer.write("]");
        writer.flush();
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ void access$100(DataTransformationService x0) {
        x0.releaseResources();
    }

    static /* synthetic */ String access$200(Exception x0) {
        return DataTransformationService.buildExceptionResponseString((Exception)x0);
    }
}

