/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationservice;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import java.util.ArrayList;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransformation.datatransformationlibrary.DTSCore;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeEvaluator;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.IOHandler;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Input;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.gcube.datatransformation.datatransformationlibrary.transformation.model.TransformationDescription;
import org.gcube.datatransformation.datatransformationservice.DTSContext;
import org.gcube.datatransformation.datatransformationservice.StatisticsUpdater;
import org.gcube.datatransformation.datatransformationservice.StubsToModelUtils;
import org.gcube.datatransformation.datatransformationservice.stubs.ArrayOfDataElementIDandContentType;
import org.gcube.datatransformation.datatransformationservice.stubs.DataElementIDandContentType;
import org.gcube.datatransformation.datatransformationservice.stubs.EvaluateContentTypeByDataElementID;
import org.gcube.datatransformation.datatransformationservice.stubs.FindApplicableTransformationUnits;
import org.gcube.datatransformation.datatransformationservice.stubs.FindApplicableTransformationUnitsResponse;
import org.gcube.datatransformation.datatransformationservice.stubs.FindAvailableTargetContentTypes;
import org.gcube.datatransformation.datatransformationservice.stubs.FindAvailableTargetContentTypesResponse;
import org.gcube.datatransformation.datatransformationservice.stubs.TPAndTransformationUnit;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformData;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformDataResponse;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformDataWithTransformationProgram;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformDataWithTransformationProgramResponse;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformDataWithTransformationUnit;
import org.gcube.datatransformation.datatransformationservice.stubs.TransformDataWithTransformationUnitResponse;

public class DataTransformationService
extends GCUBEPortType {
    protected static final GCUBELog log = new GCUBELog(DataTransformationService.class);

    protected static void init() throws Exception {
        log.info((Object)"Initializing Data Transformation Service...");
        log.info((Object)"Initializing Resource Registry");
        ResourceRegistry.startBridging();
        DataTransformationService.initgRS2();
        try {
            GCUBESecurityManagerImpl smanager = new GCUBESecurityManagerImpl(){

                public boolean isSecurityEnabled() {
                    return DTSContext.getContext().isSecurityEnabled();
                }
            };
            DTSSManager.setSecurityManager((GCUBESecurityManager)smanager);
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize the security managener", (Throwable)e);
            throw new Exception("Could not initialize the security managener");
        }
        try {
            DTSSManager.init((GCUBEServiceContext)DTSContext.getContext());
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize DTSSManager", (Throwable)e);
            throw new Exception("Could not initialize DTSCore");
        }
        try {
            IOHandler.init(null);
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize IOHandler", (Throwable)e);
            throw new Exception("Could not initialize IOHandler");
        }
        new StatisticsUpdater();
    }

    private static void initgRS2() {
        Integer gRS2Port = (int)((Integer)DTSContext.getContext().getProperty(DTSContext.GRS2_PORT, new boolean[]{true}));
        log.info((Object)("Setting gRS2 port to " + gRS2Port));
        PortRange ports = new PortRange(gRS2Port.intValue(), gRS2Port.intValue());
        ArrayList<PortRange> portranges = new ArrayList<PortRange>();
        portranges.add(ports);
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(GHNContext.getContext().getHostname(), portranges, true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }

    public TransformDataResponse transformData(TransformData params) throws GCUBEFault {
        DataSource source;
        ContentType targetContentType;
        DataTransformationService.initTransaction();
        try {
            targetContentType = StubsToModelUtils.contentTypeFromStub(params.getTargetContentType());
        }
        catch (Exception e) {
            log.error((Object)"Target content type not properly set", (Throwable)e);
            throw new GCUBEUnrecoverableException("Target content type not properly set", (Throwable)e).toFault(new String[0]);
        }
        try {
            ReportManager.initializeReport((boolean)params.isCreateReport());
        }
        catch (Exception e) {
            log.error((Object)"Could not create report but continuing with the transformation...", (Throwable)e);
        }
        try {
            source = IOHandler.getDataSource((Input)StubsToModelUtils.inputFromStub(params.getInput()));
        }
        catch (Exception e) {
            log.error((Object)"Could not create data source", (Throwable)e);
            this.releaseResources();
            throw new GCUBEUnrecoverableException("Could not create DataSource from the given Input", (Throwable)e).toFault(new String[0]);
        }
        TransformationDescription tDesc = new TransformationDescription(StubsToModelUtils.inputFromStub(params.getInput()), StubsToModelUtils.outputFromStub(params.getOutput()));
        DTSCore dCore = DTSSManager.getDTSCore();
        try {
            dCore.initializeAdaptor(tDesc);
        }
        catch (Exception e) {
            this.releaseResources();
            log.error((Object)"Could not initialize workflow adaptor", (Throwable)e);
            throw new GCUBEUnrecoverableException("Could not initialize workflow adaptor for the Data Transformation", (Throwable)e).toFault(new String[0]);
        }
        try {
            dCore.transformData(source, targetContentType);
        }
        catch (Exception e) {
            this.releaseResources();
            log.error((Object)"Did not manage to perform the transformation", (Throwable)e);
            throw new GCUBEUnrecoverableException("Did not manage to perform the transformation", (Throwable)e).toFault(new String[0]);
        }
        TransformDataResponse response = new TransformDataResponse();
        String output = tDesc.getReturnedValue();
        log.debug((Object)("Returning output " + output));
        response.setOutput(output);
        if (ReportManager.isReportingEnabled()) {
            try {
                response.setReportEPR(ReportManager.getReport().getReportEndpoint());
                log.debug((Object)("Report RS EPR: " + ReportManager.getReport().getReportEndpoint()));
            }
            catch (Exception e) {
                log.error((Object)"Could not get the RS EPR of the Report, but continuing nevertheless...", (Throwable)e);
            }
        }
        return response;
    }

    public TransformDataWithTransformationProgramResponse transformDataWithTransformationProgram(TransformDataWithTransformationProgram params) throws GCUBEFault {
        DataSource source;
        ContentType targetContentType;
        DataTransformationService.initTransaction();
        String transformationProgramID = params.getTPID();
        if (transformationProgramID == null || transformationProgramID.trim().length() == 0) {
            log.error((Object)"Transformation program ID not set");
            throw new GCUBEFault(new String[]{"Transformation program ID not set"});
        }
        try {
            targetContentType = StubsToModelUtils.contentTypeFromStub(params.getTargetContentType());
        }
        catch (Exception e) {
            log.error((Object)"Target content type not properly set", (Throwable)e);
            throw new GCUBEUnrecoverableException("Target content type not properly set", (Throwable)e).toFault(new String[0]);
        }
        Parameter[] unboundProgramParameters = null;
        try {
            unboundProgramParameters = StubsToModelUtils.parametersFromStub(params.getTProgramUnboundParameters());
        }
        catch (Exception e) {
            log.error((Object)"Undefined error when converting unbound parameters from stub to model parameter type", (Throwable)e);
        }
        try {
            ReportManager.initializeReport((boolean)params.isCreateReport());
        }
        catch (Exception e) {
            log.error((Object)"Could not create report but continuing with the transformation...", (Throwable)e);
        }
        try {
            source = IOHandler.getDataSource((Input)StubsToModelUtils.inputFromStub(params.getInput()));
        }
        catch (Exception e) {
            this.releaseResources();
            log.error((Object)"Could not create data source", (Throwable)e);
            throw new GCUBEUnrecoverableException("Could not create DataSource from the given Input", (Throwable)e).toFault(new String[0]);
        }
        TransformationDescription tDesc = new TransformationDescription(StubsToModelUtils.inputFromStub(params.getInput()), StubsToModelUtils.outputFromStub(params.getOutput()));
        DTSCore dCore = DTSSManager.getDTSCore();
        try {
            dCore.initializeAdaptor(tDesc);
        }
        catch (Exception e) {
            this.releaseResources();
            log.error((Object)"Could not initialize workflow adaptor", (Throwable)e);
            throw new GCUBEUnrecoverableException("Could not initialize workflow adaptor for the Data Transformation", (Throwable)e).toFault(new String[0]);
        }
        try {
            dCore.transformDataWithTransformationProgram(source, transformationProgramID, unboundProgramParameters, targetContentType);
        }
        catch (Exception e) {
            this.releaseResources();
            log.error((Object)"Could not perform the transformation", (Throwable)e);
            throw new GCUBEUnrecoverableException("Could not perform the transformation", (Throwable)e).toFault(new String[0]);
        }
        TransformDataWithTransformationProgramResponse response = new TransformDataWithTransformationProgramResponse();
        String output = tDesc.getReturnedValue();
        log.debug((Object)("Returning output " + output));
        response.setOutput(output);
        if (ReportManager.isReportingEnabled()) {
            try {
                response.setReportEPR(ReportManager.getReport().getReportEndpoint());
                log.debug((Object)("Report RS EPR: " + ReportManager.getReport().getReportEndpoint()));
            }
            catch (Exception e) {
                log.error((Object)"Could not get the RS EPR of the Report, but continuing nevertheless...", (Throwable)e);
            }
        }
        return response;
    }

    public TransformDataWithTransformationUnitResponse transformDataWithTransformationUnit(TransformDataWithTransformationUnit params) throws GCUBEFault {
        ContentType targetContentType;
        DataTransformationService.initTransaction();
        String TProgramID = params.getTPID();
        if (TProgramID == null || TProgramID.trim().length() == 0) {
            log.error((Object)"Transformation program ID not set");
            throw new GCUBEFault(new String[]{"Transformation program ID not set"});
        }
        String transformationUnitID = params.getTransformationUnitID();
        if (transformationUnitID == null || transformationUnitID.trim().length() == 0) {
            log.error((Object)"Transformation unit ID not set");
            throw new GCUBEFault(new String[]{"Transformation unit ID not set"});
        }
        try {
            targetContentType = StubsToModelUtils.contentTypeFromStub(params.getTargetContentType());
        }
        catch (Exception e) {
            log.error((Object)"Target content type not properly set", (Throwable)e);
            throw new GCUBEUnrecoverableException("Target content type not properly set", (Throwable)e).toFault(new String[0]);
        }
        Parameter[] unboundProgramParameters = null;
        try {
            unboundProgramParameters = StubsToModelUtils.parametersFromStub(params.getTProgramUnboundParameters());
        }
        catch (Exception e) {
            log.error((Object)"Undefined error when converting unbound parameters from stub to model parameter type", (Throwable)e);
        }
        try {
            ReportManager.initializeReport((boolean)params.isCreateReport());
        }
        catch (Exception e) {
            log.error((Object)"Could not create report but continuing with the transformation...", (Throwable)e);
        }
        boolean filterSources = params.isFilterSources();
        TransformationDescription tDesc = new TransformationDescription(StubsToModelUtils.inputFromStub(params.getInputs(0)), StubsToModelUtils.outputFromStub(params.getOutput()));
        DTSCore dCore = DTSSManager.getDTSCore();
        try {
            dCore.initializeAdaptor(tDesc);
        }
        catch (Exception e) {
            this.releaseResources();
            log.error((Object)"Could not initialize workflow adaptor", (Throwable)e);
            throw new GCUBEUnrecoverableException("Could not initialize workflow adaptor for the Data Transformation", (Throwable)e).toFault(new String[0]);
        }
        try {
            dCore.transformDataWithTransformationUnit(TProgramID, transformationUnitID, unboundProgramParameters, targetContentType, filterSources);
        }
        catch (Exception e) {
            this.releaseResources();
            log.error((Object)"Could not perform the requested transformation WithKnownTPIDAndTransformationID", (Throwable)e);
            throw new GCUBEUnrecoverableException("Could not perform the requested transformation with transformation unit.", (Throwable)e).toFault(new String[0]);
        }
        TransformDataWithTransformationUnitResponse response = new TransformDataWithTransformationUnitResponse();
        String output = tDesc.getReturnedValue();
        log.debug((Object)("Returning output " + output));
        response.setOutput(output);
        if (ReportManager.isReportingEnabled()) {
            try {
                response.setReportEPR(ReportManager.getReport().getReportEndpoint());
                log.debug((Object)("Report RS EPR: " + ReportManager.getReport().getReportEndpoint()));
            }
            catch (Exception e) {
                log.error((Object)"Could not get the RS EPR of the Report, but continuing nevertheless...", (Throwable)e);
            }
        }
        return response;
    }

    private void releaseResources() {
        if (ReportManager.isReportingEnabled()) {
            try {
                ReportManager.closeReport();
            }
            catch (Exception e) {
                log.error((Object)"Could not close report", (Throwable)e);
            }
        }
    }

    public FindApplicableTransformationUnitsResponse findApplicableTransformationUnits(FindApplicableTransformationUnits params) throws GCUBEFault {
        ArrayList transformations;
        ContentType targetContentType;
        ContentType sourceContentType;
        DataTransformationService.initTransaction();
        try {
            sourceContentType = StubsToModelUtils.contentTypeFromStub(params.getSourceContentType());
        }
        catch (Exception e) {
            log.error((Object)"Source content type not properly set", (Throwable)e);
            throw new GCUBEUnrecoverableException("Source content type not properly set", (Throwable)e).toFault(new String[0]);
        }
        try {
            targetContentType = StubsToModelUtils.contentTypeFromStub(params.getTargetContentType());
        }
        catch (Exception e) {
            log.error((Object)"Target content type not properly set", (Throwable)e);
            throw new GCUBEUnrecoverableException("Target content type not properly set", (Throwable)e).toFault(new String[0]);
        }
        boolean createAndPublishCompositeTP = params.isCreateAndPublishCompositeTP();
        DTSCore dCore = DTSSManager.getDTSCore();
        try {
            transformations = dCore.findApplicableTransformationUnits(sourceContentType, targetContentType, createAndPublishCompositeTP);
        }
        catch (Exception e) {
            log.error((Object)"Did not manage to search for applicable transformation units", (Throwable)e);
            throw new GCUBEUnrecoverableException("Did not manage to search for applicable transformation units", (Throwable)e).toFault(new String[0]);
        }
        FindApplicableTransformationUnitsResponse response = new FindApplicableTransformationUnitsResponse();
        if (transformations != null && transformations.size() > 0) {
            ArrayList<TPAndTransformationUnit> TPAndTransformationUnitList = new ArrayList<TPAndTransformationUnit>();
            for (TransformationUnit transformation : transformations) {
                TPAndTransformationUnit tpandtrid = new TPAndTransformationUnit();
                tpandtrid.setTransformationUnitID(transformation.getId());
                tpandtrid.setTransformationProgramID(transformation.getTransformationProgram().getId());
                TPAndTransformationUnitList.add(tpandtrid);
            }
            response.setTPAndTransformationUnitIDs(TPAndTransformationUnitList.toArray(new TPAndTransformationUnit[TPAndTransformationUnitList.size()]));
        }
        return response;
    }

    public FindAvailableTargetContentTypesResponse findAvailableTargetContentTypes(FindAvailableTargetContentTypes request) throws GCUBEFault {
        ArrayList targetContentTypes;
        ContentType sourceContentType;
        DataTransformationService.initTransaction();
        try {
            sourceContentType = StubsToModelUtils.contentTypeFromStub(request.getSourceContentType());
        }
        catch (Exception e) {
            log.error((Object)"Source content type not properly set", (Throwable)e);
            throw new GCUBEUnrecoverableException("Source content type not properly set", (Throwable)e).toFault(new String[0]);
        }
        DTSCore dCore = DTSSManager.getDTSCore();
        try {
            targetContentTypes = dCore.getAvailableTargetContentTypes(sourceContentType);
        }
        catch (Exception e) {
            log.error((Object)"Did not manage to search for available target content types", (Throwable)e);
            throw new GCUBEUnrecoverableException("Did not manage to search for available target content types", (Throwable)e).toFault(new String[0]);
        }
        FindAvailableTargetContentTypesResponse response = new FindAvailableTargetContentTypesResponse();
        response.setTargetContentTypes(StubsToModelUtils.contentTypeArrayToStub(targetContentTypes));
        return response;
    }

    public String queryTransformationPrograms(String query) throws GCUBEFault {
        DataTransformationService.initTransaction();
        DTSCore dCore = DTSSManager.getDTSCore();
        try {
            return dCore.getIManager().queryTransformationPrograms(query);
        }
        catch (Exception e) {
            log.error((Object)"Could not query transfomration programs", (Throwable)e);
            throw new GCUBEUnrecoverableException("Could not query transfomration programs", (Throwable)e).toFault(new String[0]);
        }
    }

    public ArrayOfDataElementIDandContentType evaluateContentTypeByDataElementID(EvaluateContentTypeByDataElementID request) throws GCUBEFault {
        ContentTypeEvaluator evaluator;
        log.debug((Object)("Invocation to evaluateContentTypeByDataElementID for evaluator type: " + request.getEvaluatorType()));
        String[] dataElementIDs = request.getDataElementIDs();
        if (dataElementIDs == null || dataElementIDs.length == 0) {
            throw new GCUBEFault(new String[]{"Object IDs to evaluate their ContentType are not set"});
        }
        DataTransformationService.initTransaction();
        try {
            evaluator = IOHandler.getContentTypeEvaluator((String)request.getEvaluatorType());
        }
        catch (Exception e) {
            log.error((Object)"Could not create ContentTypeEvaluator", (Throwable)e);
            throw new GCUBEUnrecoverableException("Could not create ContentTypeEvaluator", (Throwable)e).toFault(new String[0]);
        }
        ArrayList<DataElementIDandContentType> objectIDandContentTypeList = new ArrayList<DataElementIDandContentType>();
        log.debug((Object)("Going to get the content format for " + dataElementIDs.length + " objects"));
        for (String dataElementID : dataElementIDs) {
            try {
                DataElementIDandContentType dataElementIDandContentType = new DataElementIDandContentType();
                dataElementIDandContentType.setDataElementID(dataElementID);
                dataElementIDandContentType.setContentType(StubsToModelUtils.contentTypeToStub(evaluator.evaluateContentTypeOfDataElement(dataElementID)));
                objectIDandContentTypeList.add(dataElementIDandContentType);
            }
            catch (Exception e) {
                log.error((Object)("Could not get content format for object " + dataElementID), (Throwable)e);
            }
        }
        log.debug((Object)("Managed to find the content format for " + objectIDandContentTypeList.size() + " objects"));
        ArrayOfDataElementIDandContentType response = new ArrayOfDataElementIDandContentType();
        response.setDataElementIDAndContentType(objectIDandContentTypeList.toArray(new DataElementIDandContentType[objectIDandContentTypeList.size()]));
        return response;
    }

    private static void initTransaction() {
        try {
            DTSSManager.useCredentials((SecurityCredentials)DTSContext.getContext().getCallerCredentials());
        }
        catch (Exception e) {
            log.warn((Object)"Could not get Caller Credentials", (Throwable)e);
        }
        DTSSManager.setScope((String)DTSContext.getContext().getScope().toString());
    }

    protected GCUBEServiceContext getServiceContext() {
        return DTSContext.getContext();
    }
}

