package org.gcube.datatransformation.datatransformationservice;

import java.util.ArrayList;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransformation.datatransformationservice.stubs.ArrayOfContentTypes;
import org.gcube.datatransformation.datatransformationservice.stubs.ContentType;
import org.gcube.datatransformation.datatransformationservice.stubs.Input;
import org.gcube.datatransformation.datatransformationservice.stubs.Output;
import org.gcube.datatransformation.datatransformationservice.stubs.Parameter;

/**
 * @author Dimitris Katris, NKUA
 * 
 * Helper class that converts stub objects from model objects and the reverse.
 */
public class StubsToModelUtils {
	
	/**
	 * Logs operations performed by {@link StubsToModelUtils} class
	 */
	private static GCUBELog log = new GCUBELog(StubsToModelUtils.class);

	/**
	 * Returns a model {@link org.gcube.datatransformation.datatransformationlibrary.model.ContentType} from a stub {@link ContentType} 
	 * 
	 * @param contentType The stub {@link ContentType}
	 * @return The model {@link org.gcube.datatransformation.datatransformationlibrary.model.ContentType}
	 * @throws Exception If an error in conversion occurred.
	 */
	public static org.gcube.datatransformation.datatransformationlibrary.model.ContentType contentTypeFromStub(ContentType contentType) throws Exception {
		if(contentType==null){
			throw new Exception("Content type is not set");
		}
		if(contentType.getMimeType()==null){
			throw new Exception("Mimetype is not set");
		}
		org.gcube.datatransformation.datatransformationlibrary.model.ContentType mContentFormat = new org.gcube.datatransformation.datatransformationlibrary.model.ContentType();
		mContentFormat.setMimeType(contentType.getMimeType());
		if(contentType.getParameters()==null || contentType.getParameters().length==0){
			return mContentFormat;
		}
		ArrayList<org.gcube.datatransformation.datatransformationlibrary.model.Parameter> fparameterslist = new ArrayList<org.gcube.datatransformation.datatransformationlibrary.model.Parameter>();
		nextParam: for(Parameter fparam: contentType.getParameters()){
			if(fparam==null || fparam.getName()==null || fparam.getValue()==null)
				continue nextParam;
			org.gcube.datatransformation.datatransformationlibrary.model.Parameter newfparam = new org.gcube.datatransformation.datatransformationlibrary.model.Parameter();
			newfparam.setName(fparam.getName());
			newfparam.setValue(fparam.getValue());
			fparameterslist.add(newfparam);
		}
		mContentFormat.setContentTypeParameters(fparameterslist);
		return mContentFormat;
	}
	
	/**
	 * Returns an array of {@link org.gcube.datatransformation.datatransformationlibrary.model.Parameter} from an array of {@link Parameter}
	 * 
	 * @param parameters The array of {@link Parameter}
	 * @return The array of {@link org.gcube.datatransformation.datatransformationlibrary.model.Parameter}
	 */
	public static org.gcube.datatransformation.datatransformationlibrary.model.Parameter[] parametersFromStub(Parameter[] parameters){
		if(parameters==null || parameters.length==0)
			return new org.gcube.datatransformation.datatransformationlibrary.model.Parameter[0];
		
		ArrayList<org.gcube.datatransformation.datatransformationlibrary.model.Parameter> parameterslist = new ArrayList<org.gcube.datatransformation.datatransformationlibrary.model.Parameter>();
		nextParam: for(Parameter param: parameters){
			if(param==null || param.getName()==null || param.getValue()==null)
				continue nextParam;
			org.gcube.datatransformation.datatransformationlibrary.model.Parameter newparam = new org.gcube.datatransformation.datatransformationlibrary.model.Parameter();
			newparam.setName(param.getName());
			newparam.setValue(param.getValue());
			log.debug("Parameter passed (Name, Value): "+param.getName()+" , "+param.getValue());
			parameterslist.add(newparam);
		}
		return parameterslist.toArray(new org.gcube.datatransformation.datatransformationlibrary.model.Parameter[parameterslist.size()]);
	}
	
	/**
	 * Returns a stub {@link ContentType} from a model {@link org.gcube.datatransformation.datatransformationlibrary.model.ContentType}.
	 * 
	 * @param contentType The model {@link org.gcube.datatransformation.datatransformationlibrary.model.ContentType}
	 * @return The stub {@link ContentType}
	 * @throws Exception If an error in conversion occurred.
	 */
	public static ContentType contentTypeToStub(org.gcube.datatransformation.datatransformationlibrary.model.ContentType contentType) throws Exception {
		if(contentType==null){
			throw new Exception("Content type is not set");
		}
		if(contentType.getMimeType()==null){
			throw new Exception("Mimetype is not set");
		}
		ContentType sContentFormat = new ContentType();
		sContentFormat.setMimeType(contentType.getMimeType());
		if(contentType.getContentTypeParameters()==null || contentType.getContentTypeParameters().size()==0){
			sContentFormat.setParameters(new Parameter[0]);
			return sContentFormat;
		}
		ArrayList<Parameter> fparameterslist = new ArrayList<Parameter>();
		nextParam: for(org.gcube.datatransformation.datatransformationlibrary.model.Parameter fparam: contentType.getContentTypeParameters()){
			if(fparam==null || fparam.getName()==null || fparam.getValue()==null)
				continue nextParam;
			Parameter newfparam = new Parameter();
			newfparam.setName(fparam.getName());
			newfparam.setValue(fparam.getValue());
			fparameterslist.add(newfparam);
		}
		sContentFormat.setParameters(fparameterslist.toArray(new Parameter[fparameterslist.size()]));
		return sContentFormat;
	}
	
	
	/**
	 * Returns an array of stub {@link ContentType} from an {@link ArrayList} of model {@link org.gcube.datatransformation.datatransformationlibrary.model.ContentType} 
	 * 
	 * @param contentTypesList The {@link ArrayList} of model {@link org.gcube.datatransformation.datatransformationlibrary.model.ContentType}
	 * @return The array of {@link ContentType}s
	 */
	public static ArrayOfContentTypes contentTypeArrayToStub(ArrayList<org.gcube.datatransformation.datatransformationlibrary.model.ContentType> contentTypesList){
		ArrayList<ContentType> sContentFormatsList = new ArrayList<ContentType>();
		for(org.gcube.datatransformation.datatransformationlibrary.model.ContentType contentFormat: contentTypesList){
			try {
				sContentFormatsList.add(contentTypeToStub(contentFormat));
			} catch (Exception e) {
				log.error("Did not manage to append in the list a content type");
			}
		}
		ArrayOfContentTypes array = new ArrayOfContentTypes();
		array.setContentTypesArray(sContentFormatsList.toArray(new ContentType[sContentFormatsList.size()]));
		return array;
	}
	
	/**
	 * Returns model's Input constructed from stubs Input
	 * 
	 * @param stubInput
	 * @return
	 */
	public static org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Input inputFromStub(Input stubInput) {
		return new org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Input(stubInput.getInputType(), stubInput.getInputValue(), parametersFromStub(stubInput.getInputparameters()));
	}
	
	
	/**
	 * Returns model's Output constructed from stubs Output
	 * 
	 * @param stubInput
	 * @return
	 */
	public static org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Output outputFromStub(Output stubOutput) {
		return new org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Output(stubOutput.getOutputType(), stubOutput.getOutputValue(), parametersFromStub(stubOutput.getOutputparameters()));
	}
}
