/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationservice.clients;

import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;

public class UploadTransformationProgram {
    static GCUBESecurityManagerImpl secManager = new GCUBESecurityManagerImpl(){

        public boolean isSecurityEnabled() {
            return false;
        }
    };

    public static void main(String[] args) throws Exception {
        GCUBEGenericResource resource = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
        resource.load((Reader)new FileReader(args[0]));
        GCUBEScope voscope = GCUBEScope.getScope((String)args[1]);
        if (voscope.getType() != GCUBEScope.Type.VO) {
            System.out.println("Second argument must be the vo scope");
            return;
        }
        resource.addScope(new GCUBEScope[]{voscope});
        String voScopeToString = voscope.toString();
        if (!voScopeToString.endsWith("/")) {
            voScopeToString = voScopeToString + "/";
        }
        if (args.length > 2) {
            for (int i = 2; i < args.length; ++i) {
                GCUBEScope vrescope = GCUBEScope.getScope((String)(voScopeToString + args[i]));
                if (vrescope.getType() != GCUBEScope.Type.VRE) {
                    System.out.println(i + "th argument must be a vre");
                }
                resource.addScope(new GCUBEScope[]{vrescope});
            }
        } else {
            System.out.println("Tranformation program will be published only in VO scope");
        }
        System.out.println("TPID " + resource.getID());
        System.out.println("TPName " + resource.getName());
        System.out.println("TPType " + resource.getType());
        System.out.println("TPBody " + resource.getBody());
        for (Map.Entry entry : resource.getScopes().entrySet()) {
            System.out.println("Resource is going to be published in scope: " + entry.getValue() + " - " + (String)entry.getKey());
        }
        ISPublisher publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        publisher.registerGCUBEResource((GCUBEResource)resource, voscope, (GCUBESecurityManager)secManager);
    }
}

