/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationservice.clients;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.ContentTypeCondition;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.ContentTypeQueryObject;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.TransformationUnitQueryObject;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ISQueryTest {
    static GCUBELog log = new GCUBELog(ISQueryTest.class);
    static GCUBEScope scope = GCUBEScope.getScope((String)"/gcube/devsec");

    public static void main(String[] args) throws Exception {
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", args[0])});
            List results = client.execute((ISQuery)query, scope);
            if (results == null || results.size() == 0) {
                if (results == null) {
                    log.error((Object)"NULLLLLLLLLLLLLLLLLL");
                }
                log.error((Object)("Could not find transformation program with id " + args[0]));
                throw new Exception("Could not find transformation program with id " + args[0]);
            }
            GCUBEGenericResource resource = (GCUBEGenericResource)results.get(0);
            log.info((Object)resource.getName());
        }
        catch (Exception e) {
            log.error((Object)("Could not invoke IS to find the transformation program with id " + args[0]), (Throwable)e);
            throw new Exception("Could not invoke IS to find the transformation program with id " + args[0]);
        }
    }

    public static String queryTransformation(TransformationUnitQueryObject object) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery query = client.getQuery("GCUBEResourceQuery");
        boolean putAnd = false;
        StringBuilder expression = new StringBuilder();
        expression.append("declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; ");
        expression.append("declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider'; ");
        expression.append("for $result in collection('/db/Profiles/GenericResource')//Document/Data/is:Profile/Resource ");
        expression.append("where starts-with($result/Profile/Name/string(), 'gDTSTP_') ");
        if (object.transformationProgramID != null && object.transformationProgramID.trim().length() > 0) {
            expression.append("and $result/ID/string() eq '" + object.transformationProgramID + "'");
        }
        expression.append(" return ");
        expression.append("for $resultin in $result/Profile/Body/gDTSTransformationProgram/Transformations/Transformation ");
        if (object.sourceContentTypeConditions != null && object.sourceContentTypeConditions.size() > 0 || object.targetContentTypeConditions != null && object.targetContentTypeConditions.size() > 0) {
            expression.append("where ");
            if (object.sourceContentTypeConditions != null && object.sourceContentTypeConditions.size() > 0) {
                for (ContentTypeCondition fcondition : object.sourceContentTypeConditions.values()) {
                    if (putAnd) {
                        expression.append(" and ");
                    }
                    putAnd = true;
                    if (fcondition.getMimetype() == null || fcondition.getMimesubtype() == null) {
                        if (fcondition.getMimetype() != null) {
                            expression.append("starts-with($resultin/Sources/Source/ContentFormat/Mimetype/string(), '" + fcondition.getMimetype() + "/') ");
                        }
                        if (fcondition.getMimesubtype() == null) continue;
                        expression.append("ends-with($resultin/Sources/Source/ContentFormat/Mimetype/string(), '/" + fcondition.getMimesubtype() + "') ");
                        continue;
                    }
                    expression.append("$resultin/Sources/Source/ContentFormat/Mimetype/string() eq '" + fcondition.getMimetype() + "/" + fcondition.getMimesubtype() + "' ");
                }
            }
            if (object.targetContentTypeConditions != null && object.targetContentTypeConditions.size() > 0) {
                for (ContentTypeCondition fcondition : object.targetContentTypeConditions.values()) {
                    if (putAnd) {
                        expression.append(" and ");
                    }
                    putAnd = true;
                    if (fcondition.getMimetype() == null || fcondition.getMimesubtype() == null) {
                        if (fcondition.getMimetype() != null) {
                            expression.append("starts-with($resultin/Target/ContentFormat/Mimetype/string(), '" + fcondition.getMimetype() + "/') ");
                        }
                        if (fcondition.getMimesubtype() == null) continue;
                        expression.append("ends-with($resultin/Target/ContentFormat/Mimetype/string(), '/" + fcondition.getMimesubtype() + "') ");
                        continue;
                    }
                    expression.append("$resultin/Target/ContentFormat/Mimetype/string() eq '" + fcondition.getMimetype() + "/" + fcondition.getMimesubtype() + "' ");
                }
            }
        }
        expression.append("return <Transformation><TransformationProgramID>{$result/ID/string()}</TransformationProgramID><TransformationID>{$resultin/string(@id)}</TransformationID></Transformation>");
        query.setExpression(expression.toString());
        List results = client.execute((ISQuery)query, scope);
        StringBuilder finalresult = new StringBuilder();
        finalresult.append("<Result>");
        for (XMLResult result : results) {
            log.debug((Object)("XMLRESULT\n" + result));
            finalresult.append(result.toString());
        }
        finalresult.append("</Result>");
        return finalresult.toString();
    }

    public static String queryTransformation(String targetMimeType, String ... sourceMimeTypes) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery query = client.getQuery("GCUBEResourceQuery");
        boolean putAnd = false;
        StringBuilder expression = new StringBuilder();
        expression.append("declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; ");
        expression.append("declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider'; ");
        expression.append("for $result in collection('/db/Profiles/GenericResource')//Document/Data/is:Profile/Resource ");
        expression.append("where starts-with($result/Profile/Name/string(), 'gDTSTP_') ");
        expression.append(" return ");
        expression.append("for $resultin in $result/Profile/Body/gDTSTransformationProgram/Transformations/Transformation ");
        if (targetMimeType != null && targetMimeType.trim().length() > 0) {
            expression.append("where starts-with($resultin/Target/ContentFormat/Mimetype/string(), '" + targetMimeType + "') ");
            putAnd = true;
        }
        if (sourceMimeTypes != null && sourceMimeTypes.length > 0) {
            for (String srcMimetype : sourceMimeTypes) {
                if (srcMimetype == null || srcMimetype.trim().length() <= 0) continue;
                if (putAnd) {
                    expression.append(" and ");
                }
                expression.append("where starts-with($resultin/Sources/Source/ContentFormat/Mimetype/string(), '" + srcMimetype + "') ");
            }
        }
        expression.append("return <Transformation><TransformationProgramID>{$result/ID/string()}</TransformationProgramID><TransformationID>{$resultin/string(@id)}</TransformationID></Transformation>");
        query.setExpression(expression.toString());
        List results = client.execute((ISQuery)query, scope);
        StringBuilder finalresult = new StringBuilder();
        finalresult.append("<Result>");
        for (XMLResult result : results) {
            log.debug((Object)("XMLRESULT\n" + result));
            finalresult.append(result.toString());
        }
        finalresult.append("</Result>");
        return finalresult.toString();
    }

    public static String queryContentFormat(ContentTypeQueryObject object) throws Exception {
        StringBuilder expression = new StringBuilder();
        expression.append("declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; ");
        expression.append("declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider'; ");
        expression.append("for $result in collection('/db/Profiles/GenericResource')//Document/Data/is:Profile/Resource ");
        expression.append("where starts-with($result/Profile/Name/string(), 'gDTSTP_') ");
        if (object.transformationProgramID != null && object.transformationProgramID.trim().length() > 0) {
            expression.append("and $result/ID/string() eq '" + object.transformationProgramID + "'");
        }
        expression.append(" return ");
        expression.append("for $resultin in $result/Profile/Body/gDTSTransformationProgram/Transformations/Transformation");
        if (object.transformationUnitID != null && object.transformationUnitID.trim().length() > 0) {
            expression.append("[string(@id) eq '" + object.transformationUnitID + "']");
        }
        if (object.getResultType().equals("SCONTENTTYPE")) {
            expression.append("/Sources/Source ");
        } else {
            expression.append("/Target ");
        }
        System.out.println("Mimetype: " + object.contentTypeCondition.getMimetype());
        System.out.println("Mimetype: " + object.contentTypeCondition.getMimesubtype());
        if (object.contentTypeCondition.getMimetype() == null || object.contentTypeCondition.getMimesubtype() == null) {
            if (object.contentTypeCondition.getMimetype() != null) {
                expression.append("where starts-with($resultin/ContentFormat/Mimetype/string(), '" + object.contentTypeCondition.getMimetype() + "/') ");
            }
            if (object.contentTypeCondition.getMimesubtype() != null) {
                expression.append("where ends-with($resultin/ContentFormat/Mimetype/string(), '/" + object.contentTypeCondition.getMimesubtype() + "') ");
            }
        } else {
            expression.append("where $resultin/ContentFormat/Mimetype/string() eq '" + object.contentTypeCondition.getMimetype() + "/" + object.contentTypeCondition.getMimesubtype() + "' ");
        }
        expression.append("return $resultin/ContentFormat");
        return ISQueryTest.queryContentFormatByExpression(expression.toString());
    }

    public static String queryContentFormat(String transformationProgramID, String transformationID, String mimetype, boolean isSource) throws Exception {
        StringBuilder expression = new StringBuilder();
        expression.append("declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; ");
        expression.append("declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider'; ");
        expression.append("for $result in collection('/db/Profiles/GenericResource')//Document/Data/is:Profile/Resource ");
        expression.append("where starts-with($result/Profile/Name/string(), 'gDTSTP_') ");
        if (transformationProgramID != null && transformationProgramID.trim().length() > 0) {
            expression.append("and $result/ID/string() eq '" + transformationProgramID + "'");
        }
        expression.append(" return ");
        expression.append("for $resultin in $result/Profile/Body/gDTSTransformationProgram/Transformations/Transformation");
        if (transformationID != null && transformationID.trim().length() > 0) {
            expression.append("[string(@id) eq '" + transformationID + "']");
        }
        if (isSource) {
            expression.append("/Sources/Source ");
            if (mimetype != null && mimetype.trim().length() > 0) {
                expression.append("where starts-with($resultin/ContentFormat/Mimetype/string(), '" + mimetype + "') ");
            }
        } else {
            expression.append("/Target ");
            if (mimetype != null && mimetype.trim().length() > 0) {
                expression.append("where starts-with($resultin/ContentFormat/Mimetype/string(), '" + mimetype + "') ");
            }
        }
        expression.append("return $resultin/ContentFormat");
        return ISQueryTest.queryContentFormatByExpression(expression.toString());
    }

    public static String queryContentFormatByExpression(String expression) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery query = client.getQuery("GCUBEResourceQuery");
        query.setExpression(expression);
        List results = client.execute((ISQuery)query, scope);
        if (results == null || results.size() == 0) {
            log.info((Object)"No results found");
            return "<Result/>";
        }
        StringBuilder strbuilder = new StringBuilder();
        strbuilder.append("<Result>");
        for (XMLResult result : results) {
            log.debug((Object)("Adding to doc: " + result.toString()));
            strbuilder.append(result.toString());
        }
        strbuilder.append("</Result>");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            HashSet<Integer> exist = new HashSet<Integer>();
            ByteArrayInputStream instream = new ByteArrayInputStream(strbuilder.toString().getBytes());
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(instream);
            Element resultElement = (Element)doc.getElementsByTagName("Result").item(0);
            NodeList nlist = doc.getElementsByTagName("ContentType");
            log.debug((Object)("#Results(Dublicate): " + nlist.getLength()));
            ArrayList<Element> elmsToRemove = new ArrayList<Element>();
            for (int i = 0; i < nlist.getLength(); ++i) {
                Element cformat = (Element)nlist.item(i);
                ContentType format = new ContentType();
                format.fromDOM(cformat);
                log.debug((Object)("ContentType: " + format.toString() + ", hashCode: " + format.hashCode()));
                if (!exist.contains(format.hashCode())) {
                    log.debug((Object)("Adding: " + format.toString()));
                    exist.add(format.hashCode());
                    continue;
                }
                log.debug((Object)("Removing: " + format.toString()));
                elmsToRemove.add(cformat);
            }
            for (Element elm : elmsToRemove) {
                resultElement.removeChild(elm);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return sw.getBuffer().toString();
        }
        catch (SAXException e) {
            log.error((Object)("Could not parse results document " + strbuilder.toString()), (Throwable)e);
            throw new Exception("Could not parse results document " + strbuilder.toString());
        }
        catch (TransformerException e) {
            log.error((Object)"Could not serialize document", (Throwable)e);
            throw new Exception("Could not serialize document");
        }
        catch (Exception e) {
            log.error((Object)"Could not execute query", (Throwable)e);
            throw new Exception("Could not execute query: " + e.getMessage());
        }
    }
}

