/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationservice;

import java.util.ArrayList;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransformation.datatransformationservice.stubs.ArrayOfContentTypes;
import org.gcube.datatransformation.datatransformationservice.stubs.ContentType;
import org.gcube.datatransformation.datatransformationservice.stubs.Input;
import org.gcube.datatransformation.datatransformationservice.stubs.Output;
import org.gcube.datatransformation.datatransformationservice.stubs.Parameter;

public class StubsToModelUtils {
    private static GCUBELog log = new GCUBELog(StubsToModelUtils.class);

    public static org.gcube.datatransformation.datatransformationlibrary.model.ContentType contentTypeFromStub(ContentType contentType) throws Exception {
        if (contentType == null) {
            throw new Exception("Content type is not set");
        }
        if (contentType.getMimeType() == null) {
            throw new Exception("Mimetype is not set");
        }
        org.gcube.datatransformation.datatransformationlibrary.model.ContentType mContentFormat = new org.gcube.datatransformation.datatransformationlibrary.model.ContentType();
        mContentFormat.setMimeType(contentType.getMimeType());
        if (contentType.getParameters() == null || contentType.getParameters().length == 0) {
            return mContentFormat;
        }
        ArrayList<org.gcube.datatransformation.datatransformationlibrary.model.Parameter> fparameterslist = new ArrayList<org.gcube.datatransformation.datatransformationlibrary.model.Parameter>();
        for (Parameter fparam : contentType.getParameters()) {
            if (fparam == null || fparam.getName() == null || fparam.getValue() == null) continue;
            org.gcube.datatransformation.datatransformationlibrary.model.Parameter newfparam = new org.gcube.datatransformation.datatransformationlibrary.model.Parameter();
            newfparam.setName(fparam.getName());
            newfparam.setValue(fparam.getValue());
            fparameterslist.add(newfparam);
        }
        mContentFormat.setContentTypeParameters(fparameterslist);
        return mContentFormat;
    }

    public static org.gcube.datatransformation.datatransformationlibrary.model.Parameter[] parametersFromStub(Parameter[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return new org.gcube.datatransformation.datatransformationlibrary.model.Parameter[0];
        }
        ArrayList<org.gcube.datatransformation.datatransformationlibrary.model.Parameter> parameterslist = new ArrayList<org.gcube.datatransformation.datatransformationlibrary.model.Parameter>();
        for (Parameter param : parameters) {
            if (param == null || param.getName() == null || param.getValue() == null) continue;
            org.gcube.datatransformation.datatransformationlibrary.model.Parameter newparam = new org.gcube.datatransformation.datatransformationlibrary.model.Parameter();
            newparam.setName(param.getName());
            newparam.setValue(param.getValue());
            log.debug((Object)("Parameter passed (Name, Value): " + param.getName() + " , " + param.getValue()));
            parameterslist.add(newparam);
        }
        return parameterslist.toArray(new org.gcube.datatransformation.datatransformationlibrary.model.Parameter[parameterslist.size()]);
    }

    public static ContentType contentTypeToStub(org.gcube.datatransformation.datatransformationlibrary.model.ContentType contentType) throws Exception {
        if (contentType == null) {
            throw new Exception("Content type is not set");
        }
        if (contentType.getMimeType() == null) {
            throw new Exception("Mimetype is not set");
        }
        ContentType sContentFormat = new ContentType();
        sContentFormat.setMimeType(contentType.getMimeType());
        if (contentType.getContentTypeParameters() == null || contentType.getContentTypeParameters().size() == 0) {
            sContentFormat.setParameters(new Parameter[0]);
            return sContentFormat;
        }
        ArrayList<Parameter> fparameterslist = new ArrayList<Parameter>();
        for (org.gcube.datatransformation.datatransformationlibrary.model.Parameter fparam : contentType.getContentTypeParameters()) {
            if (fparam == null || fparam.getName() == null || fparam.getValue() == null) continue;
            Parameter newfparam = new Parameter();
            newfparam.setName(fparam.getName());
            newfparam.setValue(fparam.getValue());
            fparameterslist.add(newfparam);
        }
        sContentFormat.setParameters(fparameterslist.toArray(new Parameter[fparameterslist.size()]));
        return sContentFormat;
    }

    public static ArrayOfContentTypes contentTypeArrayToStub(ArrayList<org.gcube.datatransformation.datatransformationlibrary.model.ContentType> contentTypesList) {
        ArrayList<ContentType> sContentFormatsList = new ArrayList<ContentType>();
        for (org.gcube.datatransformation.datatransformationlibrary.model.ContentType contentFormat : contentTypesList) {
            try {
                sContentFormatsList.add(StubsToModelUtils.contentTypeToStub(contentFormat));
            }
            catch (Exception e) {
                log.error((Object)"Did not manage to append in the list a content type");
            }
        }
        ArrayOfContentTypes array = new ArrayOfContentTypes();
        array.setContentTypesArray(sContentFormatsList.toArray(new ContentType[sContentFormatsList.size()]));
        return array;
    }

    public static org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Input inputFromStub(Input stubInput) {
        return new org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Input(stubInput.getInputType(), stubInput.getInputValue(), StubsToModelUtils.parametersFromStub(stubInput.getInputparameters()));
    }

    public static org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Output outputFromStub(Output stubOutput) {
        return new org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Output(stubOutput.getOutputType(), stubOutput.getOutputValue(), StubsToModelUtils.parametersFromStub(stubOutput.getOutputparameters()));
    }
}

