package org.gcube.datatransformation.datatransformationservice;

import org.gcube.common.core.contexts.GCUBEServiceContext;

/**
 * @author Dimitris Katris, NKUA
 * 
 * The context of DTS Service
 */
public class DTSContext extends GCUBEServiceContext {

	/**
	 * The JNDI name of the service 
	 * Should be the same as the service name in deploy-jndi-config.xml
	 */
	public static final String DTS_JNDI_NAME = "gcube/datatransformation/DataTransformationService";
	public static String GRS2_PORT = "gRS2Port";
	
	/** Single context instance, created eagerly */
	private static DTSContext context = new DTSContext();
	
	/** Returns context instance */
	public static DTSContext getContext() {return context;}
	
	/** Prevents accidental creation of more instances */
	private DTSContext(){};
		
	@Override
	protected String getJNDIName() {return DTS_JNDI_NAME;}

	/* (non-Javadoc)
	 * @see org.gcube.common.core.contexts.GCUBEServiceContext#onReady()
	 */
	protected void onReady() throws Exception {
	    logger.info("Ready event invoked on: " + this.getName());
	    try {
			DataTransformationService.init();
		} catch (Exception e) {
			logger.error("Could not Initialize Data Transfomration Service",e);
			throw new Exception("Could not Initialize Data Transfomration Service");
		}
	}
}
