/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationservice.clients;

import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;

public class GetTransformationPrograms2 {
    static GCUBESecurityManagerImpl secManager = new GCUBESecurityManagerImpl(){

        public boolean isSecurityEnabled() {
            return false;
        }
    };

    public static void main(String[] args) throws Exception {
        GCUBEScope scope = GCUBEScope.getScope((String)args[0]);
        GetTransformationPrograms2.getAvailableTransformationProgramIDs(scope);
    }

    public static void getAvailableTransformationProgramIDs(GCUBEScope scope) throws Exception {
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/SecondaryType", "DTSTransformationProgram")});
            List results = client.execute((ISQuery)query, scope);
            if (results.size() == 0) {
                System.out.println("Did not manage to find any available transformationUnit programs");
            } else {
                for (GCUBEGenericResource result : results) {
                    System.out.println("Found transformationUnit program " + result.getName() + " - \"" + result.getID() + "\"");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Could not invoke IS to find the available transformationUnit program IDs");
        }
    }
}

