/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationservice.clients;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.Remote;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.datatransformation.datatransformationservice.stubs.ContentType;
import org.gcube.datatransformation.datatransformationservice.stubs.DataTransformationServicePortType;
import org.gcube.datatransformation.datatransformationservice.stubs.FindApplicableTransformationUnits;
import org.gcube.datatransformation.datatransformationservice.stubs.FindApplicableTransformationUnitsResponse;
import org.gcube.datatransformation.datatransformationservice.stubs.Parameter;
import org.gcube.datatransformation.datatransformationservice.stubs.TPAndTransformationUnit;
import org.gcube.datatransformation.datatransformationservice.stubs.service.DataTransformationServiceAddressingLocator;

public class FindApplicableTransformationUnitsClient {
    public static void main(String[] args) throws Exception {
        String dtsEndpoint = null;
        String scope = null;
        if (args.length == 0) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Scope: ");
            scope = in.readLine();
            System.out.print("DTS host: ");
            String dtshost = in.readLine();
            System.out.print("DTS port: ");
            String dtsport = in.readLine();
            dtsEndpoint = "http://" + dtshost + ":" + dtsport + "/wsrf/services/gcube/datatransformation/DataTransformationService";
        } else {
            dtsEndpoint = args[0];
            scope = args[1];
        }
        EndpointReferenceType endpoint = new EndpointReferenceType();
        endpoint.setAddress(new AttributedURI(dtsEndpoint));
        DataTransformationServicePortType dts = new DataTransformationServiceAddressingLocator().getDataTransformationServicePortTypePort(endpoint);
        dts = (DataTransformationServicePortType)GCUBERemotePortTypeContext.getProxy((Remote)dts, (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        FindApplicableTransformationUnits params = new FindApplicableTransformationUnits();
        ContentType sourceContentType = new ContentType();
        sourceContentType.setMimeType("image/tiff");
        params.setSourceContentType(sourceContentType);
        ContentType targetContentType = new ContentType();
        targetContentType.setMimeType("image/png");
        Parameter tparam1 = new Parameter();
        tparam1.setName("width");
        tparam1.setValue("*");
        Parameter tparam2 = new Parameter();
        tparam2.setName("height");
        tparam2.setValue("*");
        Parameter[] tParameters = new Parameter[]{tparam1, tparam2};
        targetContentType.setParameters(tParameters);
        params.setTargetContentType(targetContentType);
        FindApplicableTransformationUnitsResponse resp = dts.findApplicableTransformationUnits(params);
        if (resp != null) {
            for (TPAndTransformationUnit tpandtr : resp.getTPAndTransformationUnitIDs()) {
                System.out.println("TP: " + tpandtr.getTransformationProgramID() + ", TR: " + tpandtr.getTransformationUnitID());
            }
        } else {
            System.out.println("No applicable transformation unit found...");
        }
    }
}

