/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.graphs;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.File2FileProgram;
import org.gcube.datatransformation.datatransformationlibrary.utils.CLIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphvizWrapper
extends File2FileProgram {
    private Logger log = LoggerFactory.getLogger((String)GraphvizWrapper.class.getName());
    private static Map<String, String> mime2ext = new HashMap<String, String>();
    private static final String extensionSeparator = ".";
    private String method;
    private String Tlang;
    private String goverlap = "true";
    private boolean parsedParameters = false;
    private String preSCommand;
    private String preTCommand = " ";

    public static void main(String[] args) throws Exception {
        ArrayList<Parameter> programParameters = new ArrayList<Parameter>();
        programParameters.add(new Parameter("method", "neato"));
        ContentType targetContentType = new ContentType();
        targetContentType.setMimeType("application/postscript");
        new GraphvizWrapper().transformFile(new File("/home/jgerbe/testArea/graphviz/traffic_lights.gv.txt"), programParameters, targetContentType, "/home/jgerbe/testArea/graphviz/output");
    }

    public File transformFile(File sourceFile, List<Parameter> programParameters, ContentType targetContentType, String targetContentPath) throws Exception {
        if (!this.parsedParameters) {
            this.Tlang = "-T" + mime2ext.get(targetContentType.getMimeType());
            this.parseCTParameters(targetContentType.getContentTypeParameters());
            this.parsePParameters(programParameters);
            this.setUPCommand();
            this.parsedParameters = true;
        }
        String finalTargetContentPath = targetContentPath + extensionSeparator + mime2ext.get(targetContentType.getMimeType());
        String command = this.preSCommand + sourceFile.getAbsolutePath() + " " + this.preTCommand + "-o " + finalTargetContentPath;
        this.log.trace("Command to use for IM: " + command);
        int returnCode = CLIUtils.executeCommand((String)command);
        if (returnCode != 0 && returnCode != 1) {
            this.log.error("Graph wasn't constructed by graphviz library");
            throw new Exception("Graph wasn't constructed by graphviz library");
        }
        File result = new File(finalTargetContentPath);
        if (!(returnCode != 1 || result.exists() && result.length() != 0L)) {
            this.log.error("Graph wasn't constructed by graphviz library");
            throw new Exception("Graph wasn't constructed by graphviz library");
        }
        return result;
    }

    private void parseCTParameters(List<Parameter> contentTypeParameters) {
        if (contentTypeParameters != null && contentTypeParameters.size() > 0) {
            for (Parameter param : contentTypeParameters) {
                this.log.trace("GV Content type Parameter: " + param.getName() + " with value " + param.getValue());
            }
        }
    }

    private void parsePParameters(List<Parameter> parameters) throws Exception {
        if (parameters != null && parameters.size() > 0) {
            for (Parameter param : parameters) {
                this.log.trace("GV Parameter: " + param.getName() + " with value " + param.getValue());
                if (param.getName().equalsIgnoreCase("method")) {
                    this.method = param.getValue();
                    if (this.method.compareTo("dot") == 0 || this.method.compareTo("neato") == 0 || this.method.compareTo("sfdp") == 0 || this.method.compareTo("fdp") == 0 || this.method.compareTo("twopi") == 0 || this.method.compareTo("circo") == 0 || this.method.compareTo("dotty") == 0 || this.method.compareTo("lefty") == 0) continue;
                    this.log.warn("method was not accepted");
                    this.method = null;
                    continue;
                }
                this.preTCommand = this.preTCommand + "-" + param.getName() + "=" + param.getValue();
            }
        }
        if (this.method == null) {
            throw new Exception("Method for Graphviz not set");
        }
    }

    private void setUPCommand() {
        this.preSCommand = this.method + " " + this.Tlang + " ";
        if (this.goverlap.compareTo("true") != 0) {
            this.preSCommand = this.preSCommand + "-Goverlap=" + this.goverlap + " ";
        }
    }

    static {
        mime2ext.put("image/svg+xml", "svg");
        mime2ext.put("image/png", "png");
        mime2ext.put("image/gif", "gif");
        mime2ext.put("application/postscript", "ps");
    }
}

