/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.metadata.xslttransformer;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gcube.datatransformation.datatransformationlibrary.DTSScope;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Program;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XSLTRetriever;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSLT_Transformer
implements Program {
    private static Logger log = LoggerFactory.getLogger(XSLT_Transformer.class);

    public void transform(List<DataSource> sources, List<Parameter> programParameters, ContentType targetContentType, DataSink sink) throws Exception {
        ArrayList<String> xsltIDs = new ArrayList<String>();
        if (programParameters == null || programParameters.size() == 0) {
            log.error("Program parameters do not contain xslt");
            throw new Exception("Program parameters do not contain xslt");
        }
        String finalftsxslt = null;
        for (Parameter param : programParameters) {
            if (param.getName().toLowerCase().startsWith("xslt") && !param.getValue().trim().endsWith("-")) {
                xsltIDs.add(param.getValue());
            }
            if (!param.getName().toLowerCase().equals("finalftsxslt") || param.getValue().trim().endsWith("-")) continue;
            finalftsxslt = param.getValue();
        }
        if (finalftsxslt != null) {
            xsltIDs.add(finalftsxslt);
        }
        ArrayList<String> xslts = new ArrayList<String>();
        for (String xsltID : xsltIDs) {
            if (xsltID != null && xsltID.trim().length() > 0) {
                log.debug("Got XSLT ID: " + xsltIDs);
                try {
                    xslts.add(XSLTRetriever.getXSLTFromIS(xsltID, DTSScope.getScope()));
                    continue;
                }
                catch (Exception e) {
                    log.error("Did not manage to retrieve the XSLT with ID " + xsltIDs + ", aborting transformation...");
                    throw new Exception("Did not manage to retrieve the XSLT with ID " + xsltIDs);
                }
            }
            log.error("Program parameters do not contain xslt");
            throw new Exception("Program parameters do not contain xslt");
        }
        ArrayList<Transformer> xsltTransformers = new ArrayList<Transformer>();
        for (String xslt : xslts) {
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer tr = factory.newTransformer(new StreamSource(new StringReader(xslt)));
                tr.setOutputProperty("omit-xml-declaration", "yes");
                for (Parameter param : programParameters) {
                    if (param.getName().toLowerCase().equals("xslt")) continue;
                    tr.setParameter(param.getName(), param.getValue());
                }
                xsltTransformers.add(tr);
            }
            catch (Exception e) {
                log.error("Failed to compile the XSLT: " + xslt, (Throwable)e);
                throw new Exception("Failed to compile the XSLT");
            }
        }
        this.transformByXSLT(sources, xsltTransformers, targetContentType, sink);
    }

    private void transformByXSLT(List<DataSource> sources, List<Transformer> xsltTransformer, ContentType targetContentType, DataSink sink) throws Exception {
        if (sources.size() != 1) {
            throw new Exception("Elm2ElmProgram is only applicable for programs with one Input");
        }
        DataSource source = sources.get(0);
        while (source.hasNext() && !sink.isClosed()) {
            log.debug("Source has next...");
            DataElement object = source.next();
            if (object != null) {
                DataElement transformedObject;
                try {
                    log.debug("Got next object with id " + object.getId());
                    transformedObject = this.transformDataElementByXSLT(object, xsltTransformer, targetContentType);
                    if (transformedObject == null) {
                        log.warn("Got null transformed object");
                        throw new NullPointerException();
                    }
                    transformedObject.setId(object.getId());
                    log.debug("Got transformed object with id: " + transformedObject.getId() + " and content format: " + transformedObject.getContentType().toString() + ", appending into the sink");
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "was transformed successfully to " + transformedObject.getContentType().toString()), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.TRANSFORMATION);
                }
                catch (Exception e) {
                    log.error("Could not transform Data Element, continuing to next...", (Throwable)e);
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "could not be transformed to " + targetContentType.toString()), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.TRANSFORMATION);
                    continue;
                }
                sink.append(transformedObject);
                log.debug("Transformed object with id: " + transformedObject.getId() + ", was appended successfully");
                continue;
            }
            log.warn("Got null object from the data source");
        }
        if (!source.hasNext()) {
            log.debug("Source does not have any objects left, closing the sink...");
        } else {
            log.debug("Sink was closed unexpectedly...");
        }
        sink.close();
    }

    private DataElement transformDataElementByXSLT(DataElement sourceDataElement, List<Transformer> xsltTransformer, ContentType targetContentType) throws Exception {
        StrDataElement transformedElement = StrDataElement.getSinkDataElement((DataElement)sourceDataElement);
        transformedElement.setContentType(targetContentType);
        transformedElement.setId(sourceDataElement.getId());
        StringWriter output = null;
        try {
            StreamSource source = sourceDataElement instanceof StrDataElement ? new StreamSource(new StringReader(((StrDataElement)sourceDataElement).getStringContent())) : new StreamSource(sourceDataElement.getContent());
            for (Transformer tr : xsltTransformer) {
                output = new StringWriter();
                tr.transform(source, new StreamResult(output));
                source = new StreamSource(new StringReader(output.toString()));
            }
        }
        catch (Exception e) {
            log.error("Failed to transform element with ID = " + sourceDataElement.getId());
            throw new Exception("Failed to transform element with ID = " + sourceDataElement.getId());
        }
        transformedElement.setContent(output.toString());
        return transformedElement;
    }
}

