/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.images;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.File2FileProgram;
import org.gcube.datatransformation.datatransformationlibrary.utils.CLIUtils;
import org.gcube.datatransformation.datatransformationlibrary.utils.FilesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageMagickWrapper
extends File2FileProgram {
    private static Map<String, String> mime2ext = new HashMap<String, String>();
    private static final String extensionSeperator = ".";
    private String method;
    private String tile;
    private String watermarkingLocalPath;
    private int dissolve = -1;
    private int width = -1;
    private int height = -1;
    private boolean parsedParameters = false;
    private String define = null;
    private boolean keepaspect = false;
    private String preSCommand;
    private String preTCommand = " ";
    private Logger log = LoggerFactory.getLogger(ImageMagickWrapper.class);
    private static final String extensionSeparator = ".";

    public static void main(String[] args) throws Exception {
        ArrayList<Parameter> programParameters = new ArrayList<Parameter>();
        programParameters.add(new Parameter("method", "composite"));
        programParameters.add(new Parameter("dissolve", "15"));
        programParameters.add(new Parameter("tile", "http://dl07.di.uoa.gr:8080/esa_logo.jpg"));
        ContentType targetContentType = new ContentType();
        targetContentType.setMimeType("image/png");
        Parameter param1 = new Parameter("width", "300");
        Parameter param2 = new Parameter("height", "300");
        targetContentType.addContentTypeParameters(new Parameter[]{param1, param2});
        new ImageMagickWrapper().transformFile(new File(args[0]), programParameters, targetContentType, args[1]);
    }

    public File transformFile(File sourceFile, List<Parameter> programParameters, ContentType targetContentType, String targetContentPath) throws Exception {
        if (!this.parsedParameters) {
            this.parseCTParameters(targetContentType.getContentTypeParameters());
            this.parsePParameters(programParameters);
            this.setUPCommand();
            this.parsedParameters = true;
        }
        String finalTargetContentPath = targetContentPath + "." + mime2ext.get(targetContentType.getMimeType());
        String command = this.preSCommand + sourceFile.getAbsolutePath() + " " + this.preTCommand + finalTargetContentPath;
        this.log.trace("Command to use for IM: " + command);
        int returnCode = CLIUtils.executeCommand((String)command);
        if (returnCode != 0 && returnCode != 1) {
            this.log.error("Image wasn't transformed by imagemagick library");
            throw new Exception("Image wasn't transformed by imagemagick library");
        }
        File result = new File(finalTargetContentPath);
        if (!(returnCode != 1 || result.exists() && result.length() != 0L)) {
            this.log.error("Image wasn't transformed by imagemagick library");
            throw new Exception("Image wasn't transformed by imagemagick library");
        }
        return result;
    }

    private void parseCTParameters(List<Parameter> contentTypeParameters) {
        if (contentTypeParameters != null && contentTypeParameters.size() > 0) {
            for (Parameter param : contentTypeParameters) {
                this.log.trace("IM Content type Parameter: " + param.getName() + " with value " + param.getValue());
                if (param.getName().equalsIgnoreCase("define")) {
                    this.define = param.getValue();
                }
                if (param.getName().equalsIgnoreCase("keep-aspect") && param.getValue().equalsIgnoreCase("true")) {
                    this.keepaspect = true;
                }
                if (param.getName().equalsIgnoreCase("width")) {
                    this.width = Integer.parseInt(param.getValue());
                }
                if (!param.getName().equalsIgnoreCase("height")) continue;
                this.height = Integer.parseInt(param.getValue());
            }
        }
    }

    private void parsePParameters(List<Parameter> parameters) throws Exception {
        if (parameters != null && parameters.size() > 0) {
            for (Parameter param : parameters) {
                this.log.trace("IM Parameter: " + param.getName() + " with value " + param.getValue());
                if (param.getName().equalsIgnoreCase("method")) {
                    this.method = param.getValue();
                }
                if (param.getName().equalsIgnoreCase("dissolve")) {
                    this.dissolve = Integer.parseInt(param.getValue());
                }
                if (!param.getName().equalsIgnoreCase("tile")) continue;
                this.tile = param.getValue();
                this.watermarkingLocalPath = this.downloadTile(this.tile);
            }
        }
        if (this.method == null) {
            throw new Exception("Method for ImageMagick not set");
        }
    }

    private String downloadTile(String tileURL) throws Exception {
        String filename = "/tmp/" + tileURL.hashCode() + "." + ImageMagickWrapper.getFileExtention(tileURL);
        FilesUtils.streamToFile((InputStream)new URL(tileURL).openStream(), (String)filename);
        return filename;
    }

    private static String getFileExtention(String fileName) {
        int dot = fileName.lastIndexOf(".");
        if (dot == -1) {
            return null;
        }
        return fileName.substring(dot + 1);
    }

    private void setUPCommand() {
        this.preSCommand = this.method + " ";
        if (this.dissolve > 0) {
            this.preSCommand = this.preSCommand + "-dissolve " + this.dissolve + " ";
        }
        if (this.define != null) {
            this.preSCommand = this.preSCommand + "-define " + this.define + " ";
        }
        if (this.watermarkingLocalPath != null) {
            this.preSCommand = this.preSCommand + "-tile " + this.watermarkingLocalPath + " ";
        }
        if (!this.method.equals("dissolve")) {
            this.preTCommand = "";
            if (this.width != -1 && this.height != -1) {
                this.preTCommand = this.preTCommand + "-thumbnail " + this.width + "x" + this.height;
                this.preTCommand = this.keepaspect ? this.preTCommand + "> " : this.preTCommand + " ";
            }
        }
    }

    static {
        mime2ext.put("image/png", "png");
        mime2ext.put("image/tiff", "tiff");
        mime2ext.put("image/jpeg", "jpeg");
        mime2ext.put("image/bmp", "bmp");
        mime2ext.put("image/gif", "gif");
    }
}

