/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.metadata.indexfeed;

import com.google.common.xml.XmlEscapers;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.gcube.datatransformation.datatransformationlibrary.DTSScope;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Program;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XMLStringParser;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XSLTRetriever;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FtsRowset_Transformer
implements Program {
    private static Logger log = LoggerFactory.getLogger(FtsRowset_Transformer.class);
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public void transform(List<DataSource> sources, List<Parameter> programParameters, ContentType targetContentType, DataSink sink) throws Exception {
        if (programParameters == null || programParameters.size() == 0) {
            log.error("Program parameters do not contain xslt");
            throw new Exception("Program parameters do not contain xslt");
        }
        ArrayList<String> xsltIDs = new ArrayList<String>();
        String finalxsltID = null;
        String indexType = null;
        Boolean base64 = false;
        for (Parameter param : programParameters) {
            if (param.getName().equalsIgnoreCase("finalftsxslt") && !param.getValue().equals("-")) {
                finalxsltID = param.getValue();
            }
            if (param.getName().matches("xslt(:[0-9][0-9]*)?")) {
                if (param.getValue().endsWith("-")) {
                    log.debug("skipping parameter " + param.getName());
                } else {
                    xsltIDs.add(param.getValue());
                }
            }
            if (param.getName().equalsIgnoreCase("indexType")) {
                indexType = param.getValue();
            }
            if (!param.getName().equalsIgnoreCase("base64")) continue;
            base64 = Boolean.valueOf(param.getValue());
        }
        log.debug("The index type is " + indexType);
        if ((xsltIDs.isEmpty() || xsltIDs.size() > 1 && finalxsltID == null) && !base64.booleanValue()) {
            log.error("Program parameters xslts are not set properly. xsltIDs: " + xsltIDs + " finalxsltID: " + finalxsltID + " toBase64: " + base64);
            throw new Exception("Program parameters xslts are not set properly. xsltIDs: " + xsltIDs + " finalxsltID: " + finalxsltID + " toBase64: " + base64);
        }
        ArrayList<Templates> compiledXSLT = new ArrayList<Templates>();
        for (String xsltID : xsltIDs) {
            compiledXSLT.add(this.createXSLTTemplates(xsltID));
        }
        Templates compiledFinalXSLT = null;
        if (finalxsltID != null) {
            compiledFinalXSLT = this.createXSLTTemplates(finalxsltID);
        }
        this.transformSources(sources, compiledXSLT, compiledFinalXSLT, targetContentType, sink, indexType, base64);
    }

    private Templates createXSLTTemplates(String xsltID) throws Exception {
        Templates compiledXSLT;
        String xslt;
        log.debug("Got XSLT ID: " + xsltID);
        try {
            xslt = XSLTRetriever.getXSLTFromIS(xsltID, DTSScope.getScope());
        }
        catch (Exception e) {
            log.error("Did not manage to retrieve the XSLT with ID " + xsltID + ", aborting transformation...");
            throw new Exception("Did not manage to retrieve the XSLT with ID " + xsltID);
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            compiledXSLT = factory.newTemplates(new StreamSource(new StringReader(xslt)));
        }
        catch (Exception e) {
            log.error("Failed to compile the XSLT: " + xslt, (Throwable)e);
            throw new Exception("Failed to compile the XSLT");
        }
        return compiledXSLT;
    }

    private void transformSources(List<DataSource> sources, List<Templates> compiledXSLTs, Templates compiledFinalXSLT, ContentType targetContentType, DataSink sink, String indexType, Boolean base64) throws Exception {
        if (sources.size() != 1) {
            throw new Exception("Elm2ElmProgram is only applicable for programs with one Input");
        }
        DataSource source = sources.get(0);
        while (source.hasNext() && !sink.isClosed()) {
            log.debug("Source has next...");
            DataElement object = source.next();
            if (object != null) {
                DataElement transformedObject;
                try {
                    log.debug("Got next object with id " + object.getId());
                    transformedObject = this.transformDataElement(object, compiledFinalXSLT, compiledXSLTs, targetContentType, indexType, base64);
                    if (transformedObject == null) {
                        log.warn("Got null transformed object...");
                        throw new Exception();
                    }
                    transformedObject.setId(object.getId());
                    log.debug("Got transformed object with id: " + transformedObject.getId() + " and content format: " + transformedObject.getContentType().toString() + ", appending into the sink");
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "was transformed successfully to " + transformedObject.getContentType().toString()), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.TRANSFORMATION);
                }
                catch (Exception e) {
                    log.error("Could not transform Data Element, continuing to next...", (Throwable)e);
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "could not be transformed to " + targetContentType.toString()), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.TRANSFORMATION);
                    continue;
                }
                log.debug("Trying to append transformed object with id: " + transformedObject.getId());
                sink.append(transformedObject);
                continue;
            }
            log.warn("Got null object from the data source");
        }
        if (!source.hasNext()) {
            log.debug("Source does not have any objects left, closing the sink...");
        } else {
            log.debug("Sink was closed unexpectedly...");
        }
        sink.close();
    }

    private DataElement transformDataElement(DataElement sourceDataElement, Templates compiledFinalXSLT, List<Templates> compiledXSLTs, ContentType targetContentType, String indexType, Boolean base64) throws Exception {
        Document doc;
        Node n;
        StrDataElement transformedElement = StrDataElement.getSinkDataElement((DataElement)sourceDataElement);
        transformedElement.setContentType(targetContentType);
        transformedElement.setId(sourceDataElement.getId());
        String transformedPayload = null;
        transformedPayload = base64 != false ? this.transformToBase64(sourceDataElement) : this.transformByXLST(sourceDataElement, compiledXSLTs, compiledFinalXSLT);
        if (compiledFinalXSLT != null) {
            transformedPayload = "<__Agregate_>" + transformedPayload + "</__Agregate_>";
            StringWriter finalOutput = new StringWriter();
            try {
                Transformer t = compiledFinalXSLT.newTransformer();
                t.setOutputProperty("omit-xml-declaration", "yes");
                t.transform(new StreamSource(new StringReader(transformedPayload)), new StreamResult(finalOutput));
            }
            catch (Exception e) {
                log.error("Failed to transform element with ID = " + sourceDataElement.getId());
                throw new Exception("Failed to transform element with ID = " + sourceDataElement.getId());
            }
            transformedPayload = finalOutput.toString();
        }
        if ((n = (Node)this.xpath.evaluate("//ROW", doc = XMLStringParser.parseXMLString(transformedPayload), XPathConstants.NODE)) == null) {
            log.warn("Couldn't find ROW element in record " + String.valueOf(sourceDataElement.getId()) + ".");
            throw new Exception("Couldn't find ROW element in record " + String.valueOf(sourceDataElement.getId()) + ".");
        }
        Element elRowset = (Element)this.xpath.evaluate("//ROWSET", doc, XPathConstants.NODE);
        elRowset.setAttribute("idxType", indexType);
        String lang = "";
        if (sourceDataElement.getAttributeValue("language") != null) {
            lang = sourceDataElement.getAttributeValue("language");
        }
        elRowset.setAttribute("lang", lang);
        log.debug("Get attribute ContentCollectionID " + sourceDataElement.getAttributeValue("CollectionID"));
        elRowset.setAttribute("colID", sourceDataElement.getAttributeValue("CollectionID"));
        Element elID = doc.createElement("FIELD");
        elID.setAttribute("name", "ObjectID");
        elID.setTextContent(sourceDataElement.getAttributeValue("ContentOID"));
        Element elRow = (Element)this.xpath.evaluate("//ROW", doc, XPathConstants.NODE);
        elRow.appendChild(elID);
        transformedPayload = XMLStringParser.XMLDocToString(doc);
        transformedElement.setContent(transformedPayload);
        return transformedElement;
    }

    private String transformToBase64(DataElement sourceDataElement) throws Exception {
        StringWriter sw = new StringWriter();
        sw.append("<ROWSET>");
        sw.append("<ROW>");
        for (Map.Entry attr : sourceDataElement.getAllAttributes().entrySet()) {
            String name = (String)attr.getKey();
            if (name.equals("CollectionID") || name.equals("ContentOID")) continue;
            if (name.matches("sid\\d+")) {
                name = "sid";
            }
            sw.append("<FIELD name=\"" + XmlEscapers.xmlAttributeEscaper().escape(name) + "\">");
            sw.append(XmlEscapers.xmlContentEscaper().escape((String)attr.getValue()));
            sw.append("</FIELD>");
        }
        sw.append("<FIELD name=\"file\">");
        if (sourceDataElement instanceof StrDataElement) {
            sw.append(Base64.encodeBase64String((byte[])((StrDataElement)sourceDataElement).getStringContent().getBytes()));
        } else {
            sw.append(Base64.encodeBase64String((byte[])IOUtils.toByteArray((InputStream)sourceDataElement.getContent())));
        }
        sw.append("</FIELD>");
        sw.append("</ROW>");
        sw.append("</ROWSET>");
        return sw.toString();
    }

    private String transformByXLST(DataElement sourceDataElement, List<Templates> compiledXSLTs, Templates compiledFinalXSLT) throws Exception {
        StringWriter output = new StringWriter();
        for (Templates compiledXSLT : compiledXSLTs) {
            try {
                Transformer t = compiledXSLT.newTransformer();
                t.setOutputProperty("omit-xml-declaration", "yes");
                if (sourceDataElement instanceof StrDataElement) {
                    t.transform(new StreamSource(new StringReader(((StrDataElement)sourceDataElement).getStringContent())), new StreamResult(output));
                    continue;
                }
                t.transform(new StreamSource(sourceDataElement.getContent()), new StreamResult(output));
            }
            catch (Exception e) {
                log.error("Failed to transform element with ID = " + sourceDataElement.getId(), (Throwable)e);
                throw new Exception("Failed to transform element with ID = " + sourceDataElement.getId());
            }
        }
        return output.toString();
    }
}

