/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.applications;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Stream2StreamProgram;
import org.gcube.datatransformation.datatransformationlibrary.utils.FilesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PPTToTextTransformer
extends Stream2StreamProgram {
    protected static String PPTMimeType = "application/vnd.ms-powerpoint";
    private static Logger log = LoggerFactory.getLogger(PPTToTextTransformer.class);

    public static void main(String[] args) throws Exception {
        FilesUtils.streamToFile((InputStream)new PPTToTextTransformer().transformStream(new FileInputStream("C:\\lala.ppt"), null, null, null), (String)"C:\\lala.txt");
    }

    public InputStream transformStream(InputStream content, ContentType sourceContentType, List<Parameter> programParameters, ContentType targetContentType) throws Exception {
        try {
            PowerPointExtractor extractor = new PowerPointExtractor(content);
            ByteArrayInputStream outputStream = new ByteArrayInputStream(extractor.getText().getBytes());
            log.debug("Convertion from ppt to text must have been performed successfully");
            return outputStream;
        }
        catch (Exception e) {
            log.error("Did not manage to perform convertion from ppt to text", (Throwable)e);
            throw new Exception("Did not manage to perform convertion from ppt to text");
        }
    }
}

