/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.applications;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Stream2StreamProgram;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFText2HTML;
import org.pdfbox.util.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFToTextHTMLTransformer
extends Stream2StreamProgram {
    private static Logger log = LoggerFactory.getLogger(PDFToTextHTMLTransformer.class);

    public InputStream transformStream(InputStream content, ContentType sourceContentType, List<Parameter> programParameters, ContentType targetContentType) throws Exception {
        log.info("PDFToTextHTML transform prog called.");
        if (targetContentType.getMimeType().equals("text/plain")) {
            try (PDDocument document = PDDocument.load((InputStream)content);){
                PDFTextStripper textExtractor = new PDFTextStripper();
                String text = textExtractor.getText(document);
                log.trace("PDFToTextHTML transform to text");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(text.getBytes());
                return byteArrayInputStream;
            }
        }
        if (targetContentType.getMimeType().equals("text/html")) {
            try (PDDocument document = PDDocument.load((InputStream)content);){
                PDFText2HTML htmlExtractor = new PDFText2HTML();
                String text = htmlExtractor.getText(document);
                log.trace("PDFToHTML transform to HTML");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(text.getBytes());
                return byteArrayInputStream;
            }
        }
        log.error("Transformation not supported...");
        throw new Exception("Transformation not supported...");
    }
}

