/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.applications;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Stream2StreamProgram;
import org.gcube.datatransformation.datatransformationlibrary.utils.FilesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelToTextTransformer
extends Stream2StreamProgram {
    protected static String EXCELMimeType = "application/vnd.ms-excel";
    private static Logger log = LoggerFactory.getLogger(ExcelToTextTransformer.class);

    public static void main(String[] args) throws Exception {
        FilesUtils.streamToFile((InputStream)new ExcelToTextTransformer().transformStream(new FileInputStream("C:\\lala.xls"), null, null, null), (String)"C:\\lala.txt");
    }

    public InputStream transformStream(InputStream content, ContentType sourceContentType, List<Parameter> programParameters, ContentType targetContentType) throws Exception {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(content);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            ExcelExtractor extractor = new ExcelExtractor(wb);
            ByteArrayInputStream outputStream = new ByteArrayInputStream(extractor.getText().getBytes());
            log.debug("Convertion from excel to text must have been performed successfully");
            return outputStream;
        }
        catch (Exception e) {
            log.error("Did not manage to perform convertion from excel to text", (Throwable)e);
            throw new Exception("Did not manage to perform convertion from excel to text");
        }
    }
}

