<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output xmlns:xsl="http://www.w3.org/1999/XSL/Transform" indent="yes" method="xml" omit-xml-declaration="yes" />
	<xsl:template xmlns:xsl="http://www.w3.org/1999/XSL/Transform" match="/">
		<ROWSET xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
			<ROW xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='nameAccordingTo']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='taxonRemarks']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='scientificName']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='class']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='scientificNameAuthorship']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='taxonomicStatus']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='genus']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='modified']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='acceptedNameUsageID']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='phylum']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='accessRights']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='kingdom']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='order']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='parentNameUsageID']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='family']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='bibliographicCitation']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='scientificNameID']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='taxonRank']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/*[local-name()='specificEpithet']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/vernacularNames/*[local-name()='language']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name(..)}.{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/vernacularNames/*[local-name()='locality']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name(..)}.{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="//DwC/vernacularNames/*[local-name()='vernacularName']">
					<xsl:if xmlns:xsl="http://www.w3.org/1999/XSL/Transform" test="normalize-space(.)">
						<FIELD xmlns:xsl="http://www.w3.org/1999/XSL/Transform" name="{local-name(..)}.{local-name()}">
							<xsl:value-of xmlns:xsl="http://www.w3.org/1999/XSL/Transform" select="normalize-space(.)" />
						</FIELD>
					</xsl:if>
				</xsl:for-each>
			</ROW>
		</ROWSET>
	</xsl:template>
</xsl:stylesheet>