/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util;

import java.util.List;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSLTRetriever {
    private static Logger log = LoggerFactory.getLogger(XSLTRetriever.class);

    public static String getXSLTFromIS(String xsltID, String scope) throws Exception {
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GenericResource.class);
        if (xsltID.startsWith("$")) {
            String xsltName = xsltID.substring(1);
            log.debug("Going to get XSLT from IS with name " + xsltName + " from scope " + scope.toString());
            query.addCondition("$resource/Profile/Name eq '" + xsltName + "'");
        } else {
            log.debug("Going to get XSLT from IS with ID " + xsltID + " from scope " + scope.toString());
            query.addCondition("$resource/ID eq '" + xsltID + "'");
        }
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List result = client.submit((Query)query);
        if (result == null || result.size() == 0) {
            throw new Exception("Generic resource not found.");
        }
        return ((GenericResource)result.get(0)).profile().bodyAsString();
    }
}

