/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.metadata.indexfeed;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.datatransformation.datatransformationlibrary.DTSScope;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Program;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XMLStringParser;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XSLTRetriever;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FwRowset_Transformer
implements Program {
    private static Logger log = LoggerFactory.getLogger(FwRowset_Transformer.class);
    private XPath xpath = XPathFactory.newInstance().newXPath();
    private Transformer serializer = null;
    private DOMSource serializerSource = new DOMSource();
    private static final String DEFAULTLANGUAGE = "";

    public void transform(List<DataSource> sources, List<Parameter> programParameters, ContentType targetContentType, DataSink sink) throws Exception {
        if (programParameters == null || programParameters.size() == 0) {
            log.error("Program parameters do not contain xslt");
            throw new Exception("Program parameters do not contain xslt");
        }
        ArrayList<String> xsltIDs = new ArrayList<String>();
        String finalxsltID = null;
        for (Parameter param : programParameters) {
            log.debug("Got parameter: " + param.getName() + " with value: " + param.getValue());
            if (param.getName().equalsIgnoreCase("finalfwdxslt")) {
                finalxsltID = param.getValue();
            }
            if (!param.getName().matches("xslt(:[0-9][0-9]*)?")) continue;
            if (param.getValue().endsWith("-")) {
                log.debug("skipping parameter " + param.getName());
                continue;
            }
            xsltIDs.add(param.getValue());
        }
        if (xsltIDs.isEmpty() || xsltIDs.size() > 1 && finalxsltID == null) {
            log.error("Program parameters xslts are not set properly");
            throw new Exception("Program parameters xslts are not set properly");
        }
        HashMap<String, Templates> compiledXSLT = new HashMap<String, Templates>();
        HashMap<String, Map<String, XPathExpression>> keyDescs = new HashMap<String, Map<String, XPathExpression>>();
        for (String xsltID : xsltIDs) {
            String xslt = this.retrieveXSLT(xsltID);
            compiledXSLT.put(xsltID, this.createTemplates(xslt));
            keyDescs.put(xsltID, this.createKeyDescs(xslt));
        }
        Templates compiledFinalXSLT = null;
        if (finalxsltID != null) {
            compiledFinalXSLT = this.createTemplates(this.retrieveXSLT(finalxsltID));
        } else {
            log.debug("finalfwdxslt not set");
        }
        TransformerFactory factory = null;
        try {
            factory = TransformerFactory.newInstance();
            this.serializer = factory.newTransformer();
            this.serializer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (Exception e) {
            log.error("Failed to create serializer.", (Throwable)e);
            throw new Exception("Failed to create serializer.", e);
        }
        this.transformByXSLT(sources, compiledXSLT, compiledFinalXSLT, targetContentType, sink, keyDescs);
    }

    private void transformByXSLT(List<DataSource> sources, Map<String, Templates> compiledXSLT, Templates compiledFinalXSLT, ContentType targetContentType, DataSink sink, Map<String, Map<String, XPathExpression>> keyDescs) throws Exception {
        if (sources.size() != 1) {
            throw new Exception("Elm2ElmProgram is only applicable for programs with one Input");
        }
        DataSource source = sources.get(0);
        while (source.hasNext() && !sink.isClosed()) {
            log.debug("Source has next...");
            DataElement object = source.next();
            if (object != null) {
                DataElement transformedObject;
                try {
                    log.debug("Got next object with id " + object.getId());
                    transformedObject = this.transformDataElementByXSLTs(object, compiledFinalXSLT, compiledXSLT, targetContentType, keyDescs);
                    if (transformedObject == null) {
                        log.warn("Got null transformed object...");
                        throw new Exception();
                    }
                    transformedObject.setId(object.getId());
                    log.debug("Got transformed object with id: " + transformedObject.getId() + " and content format: " + transformedObject.getContentType().toString() + ", appending into the sink");
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "was transformed successfully to " + transformedObject.getContentType().toString()), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.TRANSFORMATION);
                }
                catch (Exception e) {
                    log.error("Could not transform Data Element, continuing to next...", (Throwable)e);
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "could not be transformed to " + targetContentType.toString()), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.TRANSFORMATION);
                    continue;
                }
                sink.append(transformedObject);
                log.debug("Transformed object with id: " + transformedObject.getId() + ", was appended successfully");
                continue;
            }
            log.warn("Got null object from the data source");
        }
        if (!source.hasNext()) {
            log.debug("Source does not have any objects left, closing the sink...");
        } else {
            log.debug("Sink was closed unexpectedly...");
        }
        sink.close();
    }

    private DataElement transformDataElementByXSLTs(DataElement sourceDataElement, Templates compiledFinalXSLT, Map<String, Templates> compiledXSLTs, ContentType targetContentType, Map<String, Map<String, XPathExpression>> keyDescs) throws Exception {
        StrDataElement transformedElement = StrDataElement.getSinkDataElement((DataElement)sourceDataElement);
        transformedElement.setContentType(targetContentType);
        transformedElement.setId(sourceDataElement.getId());
        String payload = null;
        payload = sourceDataElement instanceof StrDataElement ? ((StrDataElement)sourceDataElement).getStringContent() : FwRowset_Transformer.isToString(sourceDataElement.getContent());
        StringBuilder strBuilder = new StringBuilder();
        Document transformedDoc = null;
        String transformedPayload = null;
        for (Map.Entry<String, Templates> compiledXSLT : compiledXSLTs.entrySet()) {
            StringWriter output = new StringWriter();
            try {
                Transformer t = compiledXSLT.getValue().newTransformer();
                t.setOutputProperty("omit-xml-declaration", "yes");
                t.transform(new StreamSource(new StringReader(payload)), new StreamResult(output));
            }
            catch (Exception e) {
                log.error("Failed to transform element with ID = " + sourceDataElement.getId(), (Throwable)e);
                throw new Exception("Failed to transform element with ID = " + sourceDataElement.getId());
            }
            transformedPayload = output.toString();
            transformedDoc = XMLStringParser.parseXMLString(transformedPayload);
            Element elTuple = (Element)this.xpath.evaluate("/ROWSET/INSERT/TUPLE", transformedDoc, XPathConstants.NODE);
            Element elValue = (Element)elTuple.getElementsByTagName("VALUE").item(0);
            for (Map.Entry<String, XPathExpression> keyDesc : keyDescs.get(compiledXSLT.getKey()).entrySet()) {
                String keyName = keyDesc.getKey();
                XPathExpression keyXPath = keyDesc.getValue();
                NodeList keyValueList = null;
                keyValueList = (NodeList)keyXPath.evaluate(new InputSource(new StringReader(payload)), XPathConstants.NODESET);
                if (keyValueList == null || keyValueList.getLength() <= 0) continue;
                for (int z = 0; z < keyValueList.getLength(); ++z) {
                    String keyValue = keyValueList.item(z).getTextContent();
                    log.debug("keyValue " + z + ": " + keyValue);
                    if (keyValue.trim().length() <= 0) continue;
                    Element elKeyName = transformedDoc.createElement("KEYNAME");
                    elKeyName.setTextContent(keyName);
                    Element elKeyValue = transformedDoc.createElement("KEYVALUE");
                    elKeyValue.setTextContent(keyValue);
                    Element elKey = transformedDoc.createElement("KEY");
                    elKey.appendChild(elKeyName);
                    elKey.appendChild(elKeyValue);
                    elTuple.insertBefore(elKey, elValue);
                    log.debug("Element to add: " + elKey.getTextContent());
                }
            }
            transformedPayload = XMLStringParser.XMLDocToString(transformedDoc);
            strBuilder.append(transformedPayload);
        }
        if (compiledFinalXSLT != null) {
            transformedPayload = "<__Agregate_>\n" + strBuilder.toString() + "\n</__Agregate_>";
            StringWriter finalOutput = new StringWriter();
            try {
                Transformer t = compiledFinalXSLT.newTransformer();
                t.setOutputProperty("omit-xml-declaration", "yes");
                t.transform(new StreamSource(new StringReader(transformedPayload)), new StreamResult(finalOutput));
            }
            catch (Exception e) {
                log.error("Failed to transform element with ID = " + sourceDataElement.getId());
                throw new Exception("Failed to transform element with ID = " + sourceDataElement.getId());
            }
            transformedPayload = finalOutput.toString();
        }
        transformedDoc = XMLStringParser.parseXMLString(transformedPayload);
        this.serializerSource.setNode(transformedDoc);
        Element elTuple = (Element)this.xpath.evaluate("/ROWSET/INSERT/TUPLE", transformedDoc, XPathConstants.NODE);
        Element elValue = (Element)elTuple.getElementsByTagName("VALUE").item(0);
        Element elKeyName = transformedDoc.createElement("KEYNAME");
        elKeyName.setTextContent("ObjectID");
        Element elKeyValue = transformedDoc.createElement("KEYVALUE");
        elKeyValue.setTextContent(sourceDataElement.getAttributeValue("ContentOID"));
        Element elKey = transformedDoc.createElement("KEY");
        elKey.appendChild(elKeyName);
        elKey.appendChild(elKeyValue);
        elTuple.insertBefore(elKey, elValue);
        elKeyName = transformedDoc.createElement("KEYNAME");
        elKeyName.setTextContent("gDocCollectionID");
        elKeyValue = transformedDoc.createElement("KEYVALUE");
        elKeyValue.setTextContent(sourceDataElement.getAttributeValue("CollectionID"));
        elKey = transformedDoc.createElement("KEY");
        elKey.appendChild(elKeyName);
        elKey.appendChild(elKeyValue);
        elTuple.insertBefore(elKey, elValue);
        elKeyName = transformedDoc.createElement("KEYNAME");
        elKeyName.setTextContent("gDocCollectionLang");
        elKeyValue = transformedDoc.createElement("KEYVALUE");
        elKeyValue.setTextContent(sourceDataElement.getAttributeValue("language") == null ? DEFAULTLANGUAGE : sourceDataElement.getAttributeValue("language"));
        elKey = transformedDoc.createElement("KEY");
        elKey.appendChild(elKeyName);
        elKey.appendChild(elKeyValue);
        elTuple.insertBefore(elKey, elValue);
        Element elfield = transformedDoc.createElement("FIELD");
        elfield.setTextContent(sourceDataElement.getAttributeValue("ContentOID"));
        elfield.setAttribute("name", "ObjectID");
        elValue.appendChild(elfield);
        elfield = transformedDoc.createElement("FIELD");
        elfield.setTextContent(sourceDataElement.getAttributeValue("CollectionID"));
        elfield.setAttribute("name", "gDocCollectionID");
        elValue.appendChild(elfield);
        elfield = transformedDoc.createElement("FIELD");
        elfield.setTextContent(sourceDataElement.getAttributeValue("language") == null ? DEFAULTLANGUAGE : sourceDataElement.getAttributeValue("language"));
        elfield.setAttribute("name", "gDocCollectionLang");
        elValue.appendChild(elfield);
        StringWriter sw = new StringWriter();
        StreamResult sresult = new StreamResult(sw);
        this.serializer.transform(this.serializerSource, sresult);
        String result = sw.getBuffer().toString();
        transformedElement.setContent(result);
        return transformedElement;
    }

    private String retrieveXSLT(String xsltID) throws Exception {
        String xslt;
        log.debug("Got XSLT ID: " + xsltID);
        try {
            xslt = XSLTRetriever.getXSLTFromIS(xsltID, DTSScope.getScope());
        }
        catch (Exception e) {
            log.error("Did not manage to retrieve the XSLT with ID " + xsltID + ", aborting transformation...");
            throw new Exception("Did not manage to retrieve the XSLT with ID " + xsltID);
        }
        return xslt;
    }

    private Templates createTemplates(String xslt) throws Exception {
        Templates compiledXSLT;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            compiledXSLT = factory.newTemplates(new StreamSource(new StringReader(xslt)));
        }
        catch (Exception e) {
            log.error("Failed to compile the XSLT: " + xslt, (Throwable)e);
            throw new Exception("Failed to compile the XSLT");
        }
        return compiledXSLT;
    }

    private Map<String, XPathExpression> createKeyDescs(String xslt) throws Exception {
        HashMap<String, XPathExpression> keyDescs = new HashMap<String, XPathExpression>();
        NodeList keys = null;
        boolean foundKeysDesc = true;
        try {
            keys = (NodeList)this.xpath.evaluate("//*[local-name()='variable']/self::node()[@name='keys']/key", new InputSource(new StringReader(xslt)), XPathConstants.NODESET);
        }
        catch (Exception e) {
            foundKeysDesc = false;
        }
        if (!foundKeysDesc || keys == null || keys.getLength() == 0) {
            log.error("Unable to locate the 'keys' variable in the given XSLT.Make sure the parameter is defined like this:\n<xsl:variable name=\"keys\"> <key><keyName/><keyXPath/></key> ... </xsl:param>");
            throw new Exception("Unable to locate the 'keys' variable in the given XSLT.Make sure the parameter is defined like this:\n<xsl:variable name=\"keys\"> <key><keyName/><keyXPath/></key> ... </xsl:param>");
        }
        try {
            for (int i = 0; i < keys.getLength(); ++i) {
                Node n = keys.item(i);
                String keyName = ((Element)n).getElementsByTagName("keyName").item(0).getTextContent();
                XPathExpression keyXPath = this.xpath.compile(((Element)n).getElementsByTagName("keyXPath").item(0).getTextContent());
                keyDescs.put(keyName, keyXPath);
                log.debug("Xpath: " + ((Element)n).getElementsByTagName("keyXPath").item(0).getTextContent());
            }
        }
        catch (Exception e) {
            log.error("Failed to parse and compile the key descriptions.", (Throwable)e);
            throw new Exception("Failed to parse and compile the key descriptions.", e);
        }
        return keyDescs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String isToString(InputStream instream) throws Exception {
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(instream, "UTF-8"));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            instream.close();
        }
        return ((Object)writer).toString();
    }
}

