/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.graphs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.File2FileProgram;
import org.gcube.datatransformation.datatransformationlibrary.utils.CLIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GnuplotWrapper
extends File2FileProgram {
    private static Map<String, String> mime2ext = new HashMap<String, String>();
    private static Map<String, String> mime2term = new HashMap<String, String>();
    private Logger log = LoggerFactory.getLogger((String)GnuplotWrapper.class.getName());
    private String method = "gnuplot";
    private String plot = "";
    private String dataFile;
    private boolean parsedParameters = false;
    private static final String extensionSeparator = ".";

    public File transformFile(File sourceFile, List<Parameter> programParameters, ContentType targetContentType, String targetContentPath) throws Exception {
        String finalTargetContentPath = targetContentPath + extensionSeparator + mime2ext.get(targetContentType.getMimeType());
        this.dataFile = sourceFile.getAbsolutePath();
        if (!this.parsedParameters) {
            this.parseCT(targetContentType);
            this.plot = this.plot + "set output \"" + finalTargetContentPath + "\"\n";
            this.parsePParameters(programParameters);
            this.parsedParameters = true;
        }
        this.log.trace("Plot to use for GP: " + this.plot);
        String command = this.method;
        int returnCode = CLIUtils.executeCommand((String)command, (InputStream)new ByteArrayInputStream(this.plot.getBytes()));
        if (returnCode != 0 && returnCode != 1) {
            this.log.error("Gnuplot failed to execute");
            throw new Exception("Gnuplot failed to execute");
        }
        File result = new File(finalTargetContentPath);
        if (!(returnCode != 1 || result.exists() && result.length() != 0L)) {
            this.log.error("Gnuplot failed to execute");
            throw new Exception("Gnuplot failed to execute");
        }
        return result;
    }

    private void parseCT(ContentType contentType) {
        List contentTypeParameters = contentType.getContentTypeParameters();
        if (mime2term.containsKey(contentType.getMimeType())) {
            this.plot = this.plot + "set term " + mime2term.get(contentType.getMimeType()) + "\n";
        }
        if (contentTypeParameters != null && contentTypeParameters.size() > 0) {
            for (Parameter param : contentTypeParameters) {
                this.log.trace("Content type Parameter: " + param.getName() + "=" + param.getValue());
                if (!param.getName().equalsIgnoreCase("define")) continue;
            }
        }
    }

    private void parsePParameters(List<Parameter> parameters) {
        if (parameters != null && parameters.size() > 0) {
            for (Parameter param : parameters) {
                String paramValue = param.getValue().replaceAll("\\\\\\s*\n", " ");
                for (String line : paramValue.split(System.getProperty("line.separator"))) {
                    if (line.contains("!")) {
                        this.log.info("Parameter " + line + " with value " + line + " will be removed");
                        continue;
                    }
                    if (line.toLowerCase().matches(".*set.*output.*")) {
                        this.log.info("Parameter " + line + " with value " + line + " will be removed");
                        continue;
                    }
                    if (line.toLowerCase().startsWith("plot")) {
                        String cont = line;
                        cont = cont.replace("\\", " ");
                        cont = cont.replaceAll("\\s+", " ");
                        cont = " " + cont;
                        String regex = "((?<!\\stitle\\s)(?<!\\st\\s))(')(\\S*)(')";
                        String repl = "$2" + this.dataFile + "$4";
                        cont = cont.replaceAll(regex, repl);
                        regex = "((?<!\\stitle\\s)(?<!\\st\\s))(\")(\\S*)(\")";
                        repl = "$2" + this.dataFile + "$4";
                        cont = cont.replaceAll(regex, repl);
                        cont = cont.trim();
                        this.plot = this.plot + cont + "\n";
                        continue;
                    }
                    this.log.trace("GM Parameter: " + line + "=" + line);
                    this.plot = this.plot + line + "\n";
                }
            }
        }
    }

    static {
        mime2ext.put("image/svg+xml", "svg");
        mime2ext.put("image/png", "png");
        mime2ext.put("image/gif", "gif");
        mime2ext.put("image/jpeg", "jpg");
        mime2ext.put("application/postscript", "eps");
        mime2term.put("image/svg+xml", "svg");
        mime2term.put("image/png", "pngcairo");
        mime2term.put("image/gif", "gif");
        mime2term.put("image/jpeg", "jpeg");
        mime2term.put("application/postscript", "postscript eps");
    }
}

