/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.metadata.indexfeed;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Program;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XMLStringParser;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XSLTRetriever;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GeoRowset_Transformer
implements Program {
    private static Logger log = LoggerFactory.getLogger(GeoRowset_Transformer.class);
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public void transform(List<DataSource> sources, List<Parameter> programParameters, ContentType targetContentType, DataSink sink) throws Exception {
        String xslt;
        if (programParameters == null || programParameters.size() == 0) {
            log.error("Program parameters do not contain xslt");
            throw new Exception("Program parameters do not contain xslt");
        }
        String xsltID = null;
        String indexType = null;
        for (Parameter param : programParameters) {
            if (param.getName().equalsIgnoreCase("geoxslt")) {
                xsltID = param.getValue();
            }
            if (!param.getName().equalsIgnoreCase("indexType")) continue;
            indexType = param.getValue();
        }
        log.debug("The index type is " + indexType);
        if (xsltID != null && xsltID.trim().length() > 0) {
            log.debug("Got XSLT ID: " + xsltID);
            try {
                xslt = XSLTRetriever.getXSLTFromIS(xsltID, DTSSManager.getScope());
            }
            catch (Exception e) {
                log.error("Did not manage to retrieve the XSLT with ID " + xsltID + ", aborting transformation...");
                throw new Exception("Did not manage to retrieve the XSLT with ID " + xsltID);
            }
        } else {
            log.error("Program parameters do not contain xslt");
            throw new Exception("Program parameters do not contain xslt");
        }
        Templates compiledXSLT = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            compiledXSLT = factory.newTemplates(new StreamSource(new StringReader(xslt)));
        }
        catch (Exception e) {
            log.error("Failed to compile the XSLT: " + xslt, (Throwable)e);
            throw new Exception("Failed to compile the XSLT");
        }
        this.transformByXSLT(sources, compiledXSLT, targetContentType, sink, indexType);
    }

    private void transformByXSLT(List<DataSource> sources, Templates compiledXSLT, ContentType targetContentType, DataSink sink, String indexType) throws Exception {
        if (sources.size() != 1) {
            throw new Exception("Elm2ElmProgram is only applicable for programs with one Input");
        }
        DataSource source = sources.get(0);
        while (source.hasNext()) {
            log.debug("Source has next...");
            DataElement object = source.next();
            if (object != null) {
                DataElement transformedObject;
                try {
                    log.debug("Got next object with id " + object.getId());
                    transformedObject = this.transformDataElementByXSLT(object, compiledXSLT, targetContentType, indexType);
                    if (transformedObject == null) {
                        log.warn("Got null transformed object...");
                        throw new Exception();
                    }
                    transformedObject.setId(object.getId());
                    log.debug("Got transformed object with id: " + transformedObject.getId() + " and content format: " + transformedObject.getContentType().toString() + ", appending into the sink");
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "was transformed successfully to " + transformedObject.getContentType().toString()), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.TRANSFORMATION);
                }
                catch (Exception e) {
                    log.error("Could not transform Data Element, continuing to next...", (Throwable)e);
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "could not be transformed to " + targetContentType.toString()), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.TRANSFORMATION);
                    continue;
                }
                sink.append(transformedObject);
                log.debug("Transformed object with id: " + transformedObject.getId() + ", was appended successfully");
                continue;
            }
            log.warn("Got null object from the data source");
        }
        log.debug("Source does not have any objects left, closing the sink...");
        sink.close();
    }

    private DataElement transformDataElementByXSLT(DataElement sourceDataElement, Templates compiledXSLT, ContentType targetContentType, String indexType) throws Exception {
        StrDataElement transformedElement = StrDataElement.getSinkDataElement((DataElement)sourceDataElement);
        transformedElement.setContentType(targetContentType);
        transformedElement.setId(sourceDataElement.getId());
        StringWriter output = new StringWriter();
        try {
            Transformer t = compiledXSLT.newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            if (sourceDataElement instanceof StrDataElement) {
                t.transform(new StreamSource(new StringReader(((StrDataElement)sourceDataElement).getStringContent())), new StreamResult(output));
            } else {
                t.transform(new StreamSource(sourceDataElement.getContent()), new StreamResult(output));
            }
        }
        catch (Exception e) {
            log.error("Failed to transform element with ID = " + sourceDataElement.getId());
            throw new Exception("Failed to transform element with ID = " + sourceDataElement.getId());
        }
        String transformedPayload = output.toString();
        Document doc = XMLStringParser.parseXMLString(transformedPayload);
        Node n = (Node)this.xpath.evaluate("//ROW", doc, XPathConstants.NODE);
        if (n == null) {
            log.warn("Couldn't find ROW element in record " + String.valueOf(sourceDataElement.getId()) + ".");
            throw new Exception("Couldn't find ROW element in record " + String.valueOf(sourceDataElement.getId()) + ".");
        }
        Element elRowset = (Element)this.xpath.evaluate("//ROWSET", doc, XPathConstants.NODE);
        elRowset.setAttribute("idxType", indexType);
        elRowset.setAttribute("lang", sourceDataElement.getAttributeValue("language"));
        elRowset.setAttribute("colID", sourceDataElement.getAttributeValue("ContentCollectionID"));
        NamedNodeMap attrs = n.getAttributes();
        if (attrs == null || attrs.getLength() == 0) {
            throw new Exception("ROW element has no coordination attrs");
        }
        try {
            if (attrs.getNamedItem("x1").getNodeValue().equals("NaN")) {
                return null;
            }
            if (attrs.getNamedItem("x2").getNodeValue().equals("NaN")) {
                return null;
            }
            if (attrs.getNamedItem("y1").getNodeValue().equals("NaN")) {
                return null;
            }
            if (attrs.getNamedItem("y2").getNodeValue().equals("NaN")) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ((Element)n).setAttribute("id", sourceDataElement.getAttributeValue("ContentOID"));
        transformedPayload = XMLStringParser.XMLDocToString(doc);
        transformedElement.setContent(transformedPayload);
        return transformedElement;
    }
}

