/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.metadata.indexfeed;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Program;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XMLStringParser;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XSLTRetriever;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FtsRowset_Transformer
implements Program {
    private static Logger log = LoggerFactory.getLogger(FtsRowset_Transformer.class);
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public void transform(List<DataSource> sources, List<Parameter> programParameters, ContentType targetContentType, DataSink sink) throws Exception {
        if (programParameters == null || programParameters.size() == 0) {
            log.error("Program parameters do not contain xslt");
            throw new Exception("Program parameters do not contain xslt");
        }
        ArrayList<String> xsltIDs = new ArrayList<String>();
        String finalxsltID = null;
        String indexType = null;
        for (Parameter param : programParameters) {
            if (param.getName().equalsIgnoreCase("finalftsxslt")) {
                finalxsltID = param.getValue();
            }
            if (param.getName().matches("xslt(:[0-9][0-9]*)?")) {
                if (param.getValue().endsWith("-")) {
                    log.debug("skipping parameter " + param.getName());
                } else {
                    xsltIDs.add(param.getValue());
                }
            }
            if (!param.getName().equalsIgnoreCase("indexType")) continue;
            indexType = param.getValue();
        }
        log.debug("The index type is " + indexType);
        if (xsltIDs.isEmpty() || xsltIDs.size() > 1 && finalxsltID == null) {
            log.error("Program parameters xslts are not set properly");
            throw new Exception("Program parameters xslts are not set properly");
        }
        ArrayList<Templates> compiledXSLT = new ArrayList<Templates>();
        for (String xsltID : xsltIDs) {
            compiledXSLT.add(this.createXSLTTemplates(xsltID));
        }
        Templates compiledFinalXSLT = null;
        if (finalxsltID != null) {
            compiledFinalXSLT = this.createXSLTTemplates(finalxsltID);
        }
        this.transformByXSLT(sources, compiledXSLT, compiledFinalXSLT, targetContentType, sink, indexType);
    }

    private Templates createXSLTTemplates(String xsltID) throws Exception {
        Templates compiledXSLT;
        String xslt;
        log.debug("Got XSLT ID: " + xsltID);
        try {
            xslt = XSLTRetriever.getXSLTFromIS(xsltID, DTSSManager.getScope());
        }
        catch (Exception e) {
            log.error("Did not manage to retrieve the XSLT with ID " + xsltID + ", aborting transformation...");
            throw new Exception("Did not manage to retrieve the XSLT with ID " + xsltID);
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            compiledXSLT = factory.newTemplates(new StreamSource(new StringReader(xslt)));
        }
        catch (Exception e) {
            log.error("Failed to compile the XSLT: " + xslt, (Throwable)e);
            throw new Exception("Failed to compile the XSLT");
        }
        return compiledXSLT;
    }

    private void transformByXSLT(List<DataSource> sources, List<Templates> compiledXSLTs, Templates compiledFinalXSLT, ContentType targetContentType, DataSink sink, String indexType) throws Exception {
        if (sources.size() != 1) {
            throw new Exception("Elm2ElmProgram is only applicable for programs with one Input");
        }
        DataSource source = sources.get(0);
        while (source.hasNext()) {
            log.debug("Source has next...");
            DataElement object = source.next();
            if (object != null) {
                DataElement transformedObject;
                try {
                    log.debug("Got next object with id " + object.getId());
                    transformedObject = this.transformDataElementByXSLTs(object, compiledFinalXSLT, compiledXSLTs, targetContentType, indexType);
                    if (transformedObject == null) {
                        log.warn("Got null transformed object...");
                        throw new Exception();
                    }
                    transformedObject.setId(object.getId());
                    log.debug("Got transformed object with id: " + transformedObject.getId() + " and content format: " + transformedObject.getContentType().toString() + ", appending into the sink");
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "was transformed successfully to " + transformedObject.getContentType().toString()), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.TRANSFORMATION);
                }
                catch (Exception e) {
                    log.error("Could not transform Data Element, continuing to next...", (Throwable)e);
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "could not be transformed to " + targetContentType.toString()), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.TRANSFORMATION);
                    continue;
                }
                sink.append(transformedObject);
                log.debug("Transformed object with id: " + transformedObject.getId() + ", was appended successfully");
                continue;
            }
            log.warn("Got null object from the data source");
        }
        log.debug("Source does not have any objects left, closing the sink...");
        sink.close();
    }

    private DataElement transformDataElementByXSLTs(DataElement sourceDataElement, Templates compiledFinalXSLT, List<Templates> compiledXSLTs, ContentType targetContentType, String indexType) throws Exception {
        Document doc;
        Node n;
        StrDataElement transformedElement = StrDataElement.getSinkDataElement((DataElement)sourceDataElement);
        transformedElement.setContentType(targetContentType);
        transformedElement.setId(sourceDataElement.getId());
        StringWriter output = new StringWriter();
        for (Templates compiledXSLT : compiledXSLTs) {
            try {
                Transformer t = compiledXSLT.newTransformer();
                t.setOutputProperty("omit-xml-declaration", "yes");
                if (sourceDataElement instanceof StrDataElement) {
                    t.transform(new StreamSource(new StringReader(((StrDataElement)sourceDataElement).getStringContent())), new StreamResult(output));
                    continue;
                }
                t.transform(new StreamSource(sourceDataElement.getContent()), new StreamResult(output));
            }
            catch (Exception e) {
                log.error("Failed to transform element with ID = " + sourceDataElement.getId(), (Throwable)e);
                throw new Exception("Failed to transform element with ID = " + sourceDataElement.getId());
            }
        }
        String transformedPayload = output.toString();
        if (compiledFinalXSLT != null && compiledXSLTs.size() > 1) {
            String[] splits = transformedPayload.split("\n");
            HashSet<String> stringSet = new HashSet<String>();
            for (String token : splits) {
                stringSet.add(token);
            }
            StringBuilder composer = new StringBuilder();
            composer.append("<ROWSET><ROW>");
            for (String token : stringSet) {
                if (token.startsWith("<ROWSET") || token.startsWith("<ROW") || token.startsWith("</ROWSET") || token.startsWith("</ROW")) continue;
                composer.append(token + '\n');
            }
            composer.append("</ROW></ROWSET>");
            transformedPayload = composer.toString();
            transformedPayload = "<__Agregate_>" + transformedPayload + "</__Agregate_>";
            StringWriter finalOutput = new StringWriter();
            try {
                Transformer t = compiledFinalXSLT.newTransformer();
                t.setOutputProperty("omit-xml-declaration", "yes");
                t.transform(new StreamSource(new StringReader(transformedPayload)), new StreamResult(finalOutput));
            }
            catch (Exception e) {
                log.error("Failed to transform element with ID = " + sourceDataElement.getId());
                throw new Exception("Failed to transform element with ID = " + sourceDataElement.getId());
            }
            transformedPayload = finalOutput.toString();
        }
        if ((n = (Node)this.xpath.evaluate("//ROW", doc = XMLStringParser.parseXMLString(transformedPayload), XPathConstants.NODE)) == null) {
            log.warn("Couldn't find ROW element in record " + String.valueOf(sourceDataElement.getId()) + ".");
            throw new Exception("Couldn't find ROW element in record " + String.valueOf(sourceDataElement.getId()) + ".");
        }
        Element elRowset = (Element)this.xpath.evaluate("//ROWSET", doc, XPathConstants.NODE);
        elRowset.setAttribute("idxType", indexType);
        String lang = "";
        if (sourceDataElement.getAttributeValue("language") != null) {
            lang = sourceDataElement.getAttributeValue("language");
        }
        elRowset.setAttribute("lang", lang);
        log.debug("Get attribute ContentCollectionID " + sourceDataElement.getAttributeValue("CollectionID"));
        elRowset.setAttribute("colID", sourceDataElement.getAttributeValue("CollectionID"));
        Element elID = doc.createElement("FIELD");
        elID.setAttribute("name", "ObjectID");
        elID.setTextContent(sourceDataElement.getAttributeValue("ContentOID"));
        Element elRow = (Element)this.xpath.evaluate("//ROW", doc, XPathConstants.NODE);
        elRow.appendChild(elID);
        transformedPayload = XMLStringParser.XMLDocToString(doc);
        transformedElement.setContent(transformedPayload);
        return transformedElement;
    }
}

