/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.misc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.CompoundDataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.LocalFileDataElement;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Elm2ElmProgram;
import org.gcube.datatransformation.datatransformationlibrary.tmpfilemanagement.TempFileManager;
import org.gcube.datatransformation.datatransformationlibrary.utils.MimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zipper
extends Elm2ElmProgram {
    private static Logger log = LoggerFactory.getLogger(Zipper.class);
    private String subdir;

    public DataElement transformDataElement(DataElement sourceDataElement, List<Parameter> programParameters, ContentType targetContentType) throws Exception {
        List uncompressedElements = new ArrayList<DataElement>();
        if (sourceDataElement instanceof CompoundDataElement) {
            uncompressedElements = ((CompoundDataElement)sourceDataElement).getParts();
        } else {
            uncompressedElements.add(sourceDataElement);
        }
        byte[] buf = new byte[1024];
        if (this.subdir == null) {
            this.subdir = TempFileManager.genarateTempSubDir();
        }
        LocalFileDataElement transformedDataElement = LocalFileDataElement.getSinkDataElement((DataElement)sourceDataElement);
        ContentType contentType = new ContentType();
        contentType.setMimeType("application/zip");
        transformedDataElement.setContentType(contentType);
        String outFilename = TempFileManager.generateTempFileName((String)this.subdir);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
        for (int i = 0; i < uncompressedElements.size(); ++i) {
            int len;
            DataElement uncompressedElement = (DataElement)uncompressedElements.get(i);
            InputStream in = uncompressedElement.getContent();
            String entryName = uncompressedElement.getId() + "." + MimeUtils.getFileExtension((String)uncompressedElement.getContentType().getMimeType());
            log.trace("Adding zip entry with name: " + entryName);
            out.putNextEntry(new ZipEntry(entryName));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
        out.close();
        File transformedCOntent = new File(outFilename);
        if (!transformedCOntent.exists()) {
            log.error("Zip file does not exist for data element with id " + sourceDataElement.getId());
            throw new Exception("Did not manage to create zip file for dataelement with id " + sourceDataElement.getId());
        }
        transformedDataElement.setContent(transformedCOntent);
        return transformedDataElement;
    }
}

