/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.metadata.indexfeed;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.ViewReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.MetadataProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.MetadataView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol.SMSURLConnection;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Program;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XMLStringParser;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XSLTRetriever;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AggregateFwd_Transformer
implements Program {
    private static Logger log = LoggerFactory.getLogger(AggregateFwd_Transformer.class);
    private Templates finalxslttemplate = null;
    private Map<String, List<ViewHolder>> viewsperlang = new HashMap<String, List<ViewHolder>>();
    private List<ViewHolder> allviews = new ArrayList<ViewHolder>();
    private Map<String, String> paramsviewIDholder = new HashMap<String, String>();
    private Map<String, String> paramsviewXSLTholder = new HashMap<String, String>();
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public void transform(List<DataSource> sources, List<Parameter> programParameters, ContentType targetContentType, DataSink sink) throws Exception {
        if (programParameters == null || programParameters.size() == 0) {
            log.error("Program parameters not set");
            throw new Exception("Program parameters not set");
        }
        String xsltID = null;
        for (Parameter param : programParameters) {
            log.debug("Trans FWD parama: " + param.getName());
            if (param.getName().equalsIgnoreCase("finalfwdxslt")) {
                String xslt;
                xsltID = param.getValue();
                if (xsltID != null && xsltID.trim().length() > 0) {
                    log.debug("Got final XSLT ID " + xsltID);
                    try {
                        xslt = XSLTRetriever.getXSLTFromIS(xsltID, DTSSManager.getScope());
                    }
                    catch (Exception e) {
                        log.error("Did not manage to retrieve the XSLT with ID " + xsltID + ", aborting transformation...");
                        throw new Exception("Did not manage to retrieve the XSLT with ID " + xsltID);
                    }
                } else {
                    log.error("Program parameters do not contain xslt");
                    throw new Exception("Program parameters do not contain xslt");
                }
                try {
                    TransformerFactory factory = TransformerFactory.newInstance();
                    this.finalxslttemplate = factory.newTemplates(new StreamSource(new StringReader(xslt)));
                }
                catch (Exception e) {
                    log.error("Failed to compile the XSLT: " + xslt, (Throwable)e);
                    throw new Exception("Failed to compile the XSLT");
                }
            }
            if (!param.getName().startsWith("view:")) continue;
            this.parseViewParam(param);
        }
        this.buildViewReadersXSLTs();
        this.transformByXSLT(sources, targetContentType, sink, DTSSManager.getScope());
    }

    private void buildViewReadersXSLTs() throws ISException, Exception {
        Iterator<String> views = this.paramsviewIDholder.keySet().iterator();
        while (views.hasNext()) {
            ViewHolder vholder = new ViewHolder();
            String paramID = views.next();
            vholder.XSLTname = this.paramsviewXSLTholder.get(paramID);
            vholder.ID = this.paramsviewIDholder.get(paramID);
            log.debug("About to add: " + vholder.XSLTname + " , " + vholder.ID);
            this.addCompileXSLTandKeys(vholder);
            MetadataView tView = new MetadataView(DTSSManager.getScope());
            tView.setId(vholder.ID);
            List newView = tView.findSimilar();
            vholder.reader = ((MetadataView)newView.get(0)).reader();
            vholder.lang = ((MetadataView)newView.get(0)).language();
            this.allviews.add(vholder);
            if (this.viewsperlang.containsKey(vholder.lang)) {
                this.viewsperlang.get(vholder.lang).add(vholder);
                continue;
            }
            ArrayList<ViewHolder> viewlst = new ArrayList<ViewHolder>();
            viewlst.add(vholder);
            this.viewsperlang.put(vholder.lang, viewlst);
        }
    }

    private void parseViewParam(Parameter param) throws Exception {
        log.debug("Parse param: " + param.getName() + " , " + param.getValue());
        if (param.getValue().equals("-")) {
            log.debug("Skipping: " + param.getName() + " , " + param.getValue());
            return;
        }
        String key = param.getName();
        String[] tokens = key.split(":");
        String paramID = tokens[1];
        String paramType = tokens[2];
        log.debug("Param type: " + paramType);
        if (paramType.equalsIgnoreCase("id")) {
            this.paramsviewIDholder.put(paramID, param.getValue());
            log.debug("Marked ID " + param.getValue());
        } else if (paramType.equalsIgnoreCase("XSLT")) {
            log.debug("Marked xslt " + param.getValue());
            this.paramsviewXSLTholder.put(paramID, param.getValue());
        }
    }

    private void addCompileXSLTandKeys(ViewHolder vholder) throws Exception {
        if (vholder.ID != null && vholder.ID.trim().length() > 0) {
            log.debug("Got XSLT ID " + vholder.XSLTname + " for collection : " + vholder.ID);
            try {
                vholder.XSLT = XSLTRetriever.getXSLTFromIS(vholder.XSLTname, DTSSManager.getScope());
            }
            catch (Exception e) {
                log.error("Did not manage to retrieve the XSLT with ID " + vholder.ID + ", aborting transformation...");
                throw new Exception("Did not manage to retrieve the XSLT with ID " + vholder.ID);
            }
        } else {
            log.error("Program parameters do not contain xslt");
            throw new Exception("Program parameters do not contain xslt");
        }
        TransformerFactory factory = null;
        Transformer serializer = null;
        try {
            factory = TransformerFactory.newInstance();
            vholder.compiledXSLT = factory.newTemplates(new StreamSource(new StringReader(vholder.XSLT)));
        }
        catch (Exception e) {
            log.error("Failed to compile the XSLT: " + vholder.XSLTname, (Throwable)e);
            throw e;
        }
        try {
            serializer = factory.newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (Exception e) {
            log.error("Failed to create serializer.", (Throwable)e);
            throw new Exception("Failed to create serializer.", e);
        }
        NodeList keys = null;
        boolean foundKeysDesc = true;
        try {
            keys = (NodeList)this.xpath.evaluate("//*[local-name()='variable']/self::node()[@name='keys']/key", new InputSource(new StringReader(vholder.XSLT)), XPathConstants.NODESET);
        }
        catch (Exception e) {
            foundKeysDesc = false;
        }
        if (!foundKeysDesc || keys == null || keys.getLength() == 0) {
            log.error("Unable to locate the 'keys' variable in the given XSLT.Make sure the parameter is defined like this:\n<xsl:variable name=\"keys\"> <key><keyName/><keyXPath/></key> ... </xsl:param>");
            throw new Exception("Unable to locate the 'keys' variable in the given XSLT.Make sure the parameter is defined like this:\n<xsl:variable name=\"keys\"> <key><keyName/><keyXPath/></key> ... </xsl:param>");
        }
        vholder.keyDescs = null;
        try {
            vholder.keyDescs = new Object[keys.getLength()][];
            for (int i = 0; i < keys.getLength(); ++i) {
                Node n = keys.item(i);
                vholder.keyDescs[i] = new Object[2];
                vholder.keyDescs[i][0] = ((Element)n).getElementsByTagName("keyName").item(0).getTextContent();
                vholder.keyDescs[i][1] = this.xpath.compile(((Element)n).getElementsByTagName("keyXPath").item(0).getTextContent());
                log.debug("Xpath: " + ((Element)n).getElementsByTagName("keyXPath").item(0).getTextContent());
            }
        }
        catch (Exception e) {
            log.error("Failed to parse and compile the key descriptions.", (Throwable)e);
            throw new Exception("Failed to parse and compile the key descriptions.", e);
        }
    }

    private void transformByXSLT(List<DataSource> sources, ContentType targetContentType, DataSink sink, GCUBEScope scope) throws Exception {
        if (sources.size() != 1) {
            throw new Exception("Elm2ElmProgram is only applicable for programs with one Input");
        }
        DataSource source = sources.get(0);
        while (source.hasNext()) {
            log.debug("Source has next...");
            DataElement object = source.next();
            if (object != null) {
                StrDataElement transformedObject = StrDataElement.getSinkDataElement((DataElement)object);
                try {
                    String gcubedocID = object.getAttributeValue("ContentOID");
                    log.debug("Got next object with ID " + gcubedocID);
                    MetadataProjection mp = Projections.metadata();
                    Iterator<String> langiter = this.viewsperlang.keySet().iterator();
                    String rowsetsforgdoc = "";
                    while (langiter.hasNext()) {
                        String language = langiter.next();
                        Iterator<ViewHolder> viewsiter = this.viewsperlang.get(language).iterator();
                        String payload = "";
                        while (viewsiter.hasNext()) {
                            ViewHolder viewholder = viewsiter.next();
                            String viewid = viewholder.ID;
                            log.debug("Metadata reader:" + viewid + " gdocID: " + gcubedocID);
                            GCubeDocument gdoc = null;
                            try {
                                gdoc = viewholder.reader.get(gcubedocID, (Projection)mp);
                                if (gdoc.metadata().size() > 1) {
                                    log.warn("For gdoc " + gcubedocID + " we have more than one metadata docs using view " + viewid + ". Using the first.");
                                }
                                if (gdoc.metadata().size() == 0) {
                                    log.warn("For gdoc " + gcubedocID + " we have no metadata docs. Continuing.");
                                    continue;
                                }
                                GCubeMetadata metadata = (GCubeMetadata)gdoc.metadata().iterator().next();
                                log.debug("Metadata:" + metadata.id());
                                String metaplayload = AggregateFwd_Transformer.getContent((GCubeElement)metadata, scope);
                                payload = payload + this.transformDataElementByXSLT(metaplayload, viewholder);
                            }
                            catch (Exception x) {
                                log.warn("Failed to retrive/transform document.\n\n Metadata view ID: " + viewid + "\n gDoc ID: " + gcubedocID + ". \n Continuing.");
                            }
                        }
                        payload = "<__Agregate_>" + payload + "</__Agregate_>";
                        payload = this.transformDataElementByXSLT(payload, this.finalxslttemplate);
                        payload = this.addFooterFields(payload, object, language);
                        rowsetsforgdoc = rowsetsforgdoc + payload;
                    }
                    transformedObject.setId(gcubedocID);
                    transformedObject.setContentType(targetContentType);
                    transformedObject.setContent(rowsetsforgdoc);
                    log.debug("Got transformed object with id: " + transformedObject.getId() + " and content format: " + transformedObject.getContentType().toString() + ", appending into the sink");
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + "was transformed successfully to " + transformedObject.getContentType().toString()), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.TRANSFORMATION);
                }
                catch (Exception e) {
                    log.error("Could not transform Data Element, continuing to next...", (Throwable)e);
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + "could not be transformed to " + targetContentType.toString()), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.TRANSFORMATION);
                    continue;
                }
                sink.append((DataElement)transformedObject);
                log.debug("Transformed object with id: " + transformedObject.getId() + ", was appended successfully");
                continue;
            }
            log.warn("Got null object from the data source");
        }
        log.debug("Source does not have any objects left, closing the sink...");
        sink.close();
    }

    private String transformDataElementByXSLT(String metaplayload, ViewHolder viewholder) throws Exception {
        StringWriter output = new StringWriter();
        Transformer t = viewholder.compiledXSLT.newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.transform(new StreamSource(new StringReader(metaplayload)), new StreamResult(output));
        String transformedPayload = output.toString();
        Document transformedDoc = XMLStringParser.parseXMLString(transformedPayload);
        DOMSource serializerSource = new DOMSource();
        serializerSource.setNode(transformedDoc);
        Element elTuple = (Element)this.xpath.evaluate("/ROWSET/INSERT/TUPLE", transformedDoc, XPathConstants.NODE);
        Element elValue = (Element)elTuple.getElementsByTagName("VALUE").item(0);
        for (Object[] keyDesc : viewholder.keyDescs) {
            String keyName = (String)keyDesc[0];
            XPathExpression keyXPath = (XPathExpression)keyDesc[1];
            NodeList keyValueList = null;
            keyValueList = (NodeList)keyXPath.evaluate(new InputSource(new StringReader(metaplayload)), XPathConstants.NODESET);
            if (keyValueList == null || keyValueList.getLength() <= 0) continue;
            for (int z = 0; z < keyValueList.getLength(); ++z) {
                String keyValue = keyValueList.item(z).getTextContent();
                log.debug("keyValue " + z + ": " + keyValue);
                if (keyValue.trim().length() <= 0) continue;
                Element elKeyName = transformedDoc.createElement("KEYNAME");
                elKeyName.setTextContent(keyName);
                Element elKeyValue = transformedDoc.createElement("KEYVALUE");
                elKeyValue.setTextContent(keyValue);
                Element elKey = transformedDoc.createElement("KEY");
                elKey.appendChild(elKeyName);
                elKey.appendChild(elKeyValue);
                elTuple.insertBefore(elKey, elValue);
                log.debug("Element to add: " + elKey.getTextContent());
            }
        }
        transformedPayload = XMLStringParser.XMLDocToString(transformedDoc);
        return transformedPayload;
    }

    private String addFooterFields(String transformedPayload, DataElement sourceDataElement, String lang) throws Exception {
        Document doc = XMLStringParser.parseXMLString(transformedPayload);
        Element elTuple = (Element)this.xpath.evaluate("/ROWSET/INSERT/TUPLE", doc, XPathConstants.NODE);
        Element elValue = (Element)elTuple.getElementsByTagName("VALUE").item(0);
        Element elKeyName = doc.createElement("KEYNAME");
        elKeyName.setTextContent("ObjectID");
        Element elKeyValue = doc.createElement("KEYVALUE");
        elKeyValue.setTextContent(sourceDataElement.getId());
        Element elKey = doc.createElement("KEY");
        elKey.appendChild(elKeyName);
        elKey.appendChild(elKeyValue);
        elTuple.insertBefore(elKey, elValue);
        elKeyName = doc.createElement("KEYNAME");
        elKeyName.setTextContent("gDocCollectionID");
        elKeyValue = doc.createElement("KEYVALUE");
        elKeyValue.setTextContent(sourceDataElement.getAttributeValue("CollectionID"));
        elKey = doc.createElement("KEY");
        elKey.appendChild(elKeyName);
        elKey.appendChild(elKeyValue);
        elTuple.insertBefore(elKey, elValue);
        elKeyName = doc.createElement("KEYNAME");
        elKeyName.setTextContent("gDocCollectionLang");
        elKeyValue = doc.createElement("KEYVALUE");
        elKeyValue.setTextContent(lang);
        elKey = doc.createElement("KEY");
        elKey.appendChild(elKeyName);
        elKey.appendChild(elKeyValue);
        elTuple.insertBefore(elKey, elValue);
        Element elfield = doc.createElement("FIELD");
        elfield.setTextContent(sourceDataElement.getId());
        elfield.setAttribute("name", "ObjectID");
        elValue.appendChild(elfield);
        elfield = doc.createElement("FIELD");
        elfield.setTextContent(sourceDataElement.getAttributeValue("CollectionID"));
        elfield.setAttribute("name", "gDocCollectionID");
        elValue.appendChild(elfield);
        elfield = doc.createElement("FIELD");
        elfield.setTextContent(lang);
        elfield.setAttribute("name", "gDocCollectionLang");
        elValue.appendChild(elfield);
        transformedPayload = XMLStringParser.XMLDocToString(doc);
        return transformedPayload;
    }

    private String transformDataElementByXSLT(String xmlpayload, Templates compiledXSLT) throws Exception {
        StringWriter output = new StringWriter();
        Transformer t = compiledXSLT.newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.transform(new StreamSource(new StringReader(xmlpayload)), new StreamResult(output));
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getContent(GCubeElement metadata, GCUBEScope scope) throws Exception {
        InputStream instream = AggregateFwd_Transformer.getContnetStream(metadata, scope);
        if (instream == null) {
            throw new Exception("Metadata document " + metadata.id() + " with no content.");
        }
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(instream, "UTF-8"));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            instream.close();
        }
        return ((Object)writer).toString();
    }

    private static InputStream getContnetStream(GCubeElement document, GCUBEScope scope) throws MalformedURLException, IOException {
        if (document.bytestreamURI() != null) {
            if (document.bytestreamURI().getScheme().equals("sms")) {
                try {
                    return SMSURLConnection.openConnection((URI)document.bytestreamURI(), (String)scope.toString()).getInputStream();
                }
                catch (URISyntaxException e) {
                    log.error("Cannot get stream for metadata, " + document.id(), (Throwable)e);
                    return null;
                }
            }
            return document.bytestreamURI().toURL().openStream();
        }
        if (document.bytestream() != null) {
            byte[] content = document.bytestream();
            ByteArrayInputStream ins = new ByteArrayInputStream(content);
            return ins;
        }
        return null;
    }

    class ViewHolder {
        public String ID;
        public String lang;
        public String XSLTname;
        public String XSLT;
        public Templates compiledXSLT;
        Object[][] keyDescs;
        public ViewReader reader;

        ViewHolder() {
        }
    }
}

