/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util;

import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSLTRetriever {
    private static Logger log = LoggerFactory.getLogger(XSLTRetriever.class);

    public static String getXSLTFromIS(String xsltID, GCUBEScope scope) throws Exception {
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            if (xsltID.startsWith("$")) {
                String xsltName = xsltID.substring(1);
                log.debug("Going to get XSLT from IS with name " + xsltName + " from scope " + scope.toString());
                query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", xsltName)});
            } else {
                log.debug("Going to get XSLT from IS with ID " + xsltID + " from scope " + scope.toString());
                query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", xsltID)});
            }
            List result = client.execute((ISQuery)query, scope);
            if (result == null || result.size() == 0) {
                log.error("Did not manage to find generic resource");
                throw new Exception("Did not manage to find generic resource.");
            }
            return ((GCUBEGenericResource)result.get(0)).getBody();
        }
        catch (Exception e) {
            log.error("Failed to retrieve the XSLT", (Throwable)e);
            throw new Exception("Failed to retrieve the XSLT");
        }
    }
}

