/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.applications;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Stream2StreamProgram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocToTextConverter
extends Stream2StreamProgram {
    private static Logger log = LoggerFactory.getLogger(DocToTextConverter.class);

    public InputStream transformStream(InputStream content, ContentType sourceContentType, List<Parameter> programParameters, ContentType targetContentType) throws Exception {
        try {
            WordExtractor extractor = new WordExtractor(content);
            ByteArrayInputStream outputStream = new ByteArrayInputStream(extractor.getText().getBytes());
            log.debug("Convertion from doc to text must have been performed successfully");
            return outputStream;
        }
        catch (Exception e) {
            log.error("Did not manage to perform convertion from doc to text", (Throwable)e);
            throw new Exception("Did not manage to perform convertion from doc to text");
        }
    }
}

