/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.programs.metadata.indexfeed;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.DataElement;
import org.gcube.datatransformation.datatransformationlibrary.dataelements.impl.StrDataElement;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.programs.Program;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XMLStringParser;
import org.gcube.datatransformation.datatransformationlibrary.programs.metadata.util.XSLTRetriever;
import org.gcube.datatransformation.datatransformationlibrary.reports.Record;
import org.gcube.datatransformation.datatransformationlibrary.reports.ReportManager;
import org.gcube.datatransformation.datatransformationlibrary.security.DTSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FwRowset_Transformer
implements Program {
    private static Logger log = LoggerFactory.getLogger(FwRowset_Transformer.class);
    private XPath xpath = XPathFactory.newInstance().newXPath();
    private Transformer serializer = null;
    private DOMSource serializerSource = new DOMSource();

    public void transform(List<DataSource> sources, List<Parameter> programParameters, ContentType targetContentType, DataSink sink) throws Exception {
        String xslt;
        if (programParameters == null || programParameters.size() == 0) {
            log.error("Program parameters do not contain xslt");
            throw new Exception("Program parameters do not contain xslt");
        }
        String xsltID = null;
        for (Parameter param : programParameters) {
            if (!param.getName().equalsIgnoreCase("xslt")) continue;
            xsltID = param.getValue();
        }
        if (xsltID != null && xsltID.trim().length() > 0) {
            log.debug("Got XSLT ID: " + xsltID);
            try {
                xslt = XSLTRetriever.getXSLTFromIS(xsltID, DTSSManager.getScope());
            }
            catch (Exception e) {
                log.error("Did not manage to retrieve the XSLT with ID " + xsltID + ", aborting transformation...");
                throw new Exception("Did not manage to retrieve the XSLT with ID " + xsltID, e);
            }
        } else {
            log.error("Program parameters do not contain xslt");
            throw new Exception("Program parameters do not contain xslt");
        }
        NodeList keys = null;
        Templates compiledXSLT = null;
        TransformerFactory factory = null;
        try {
            factory = TransformerFactory.newInstance();
            compiledXSLT = factory.newTemplates(new StreamSource(new StringReader(xslt)));
        }
        catch (Exception e) {
            log.error("Failed to compile the XSLT: " + xslt, (Throwable)e);
            throw new Exception("Failed to compile the XSLT", e);
        }
        try {
            this.serializer = factory.newTransformer();
            this.serializer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (Exception e) {
            log.error("Failed to create serializer.", (Throwable)e);
            throw new Exception("Failed to create serializer.", e);
        }
        boolean foundKeysDesc = true;
        try {
            keys = (NodeList)this.xpath.evaluate("//*[local-name()='variable']/self::node()[@name='keys']/key", new InputSource(new StringReader(xslt)), XPathConstants.NODESET);
        }
        catch (Exception e) {
            foundKeysDesc = false;
        }
        if (!foundKeysDesc || keys == null || keys.getLength() == 0) {
            log.error("Unable to locate the 'keys' variable in the given XSLT.Make sure the parameter is defined like this:\n<xsl:variable name=\"keys\"> <key><keyName/><keyXPath/></key> ... </xsl:param>");
            throw new Exception("Unable to locate the 'keys' variable in the given XSLT.Make sure the parameter is defined like this:\n<xsl:variable name=\"keys\"> <key><keyName/><keyXPath/></key> ... </xsl:param>");
        }
        Object[][] keyDescs = null;
        try {
            keyDescs = new Object[keys.getLength()][];
            for (int i = 0; i < keys.getLength(); ++i) {
                Node n = keys.item(i);
                keyDescs[i] = new Object[2];
                keyDescs[i][0] = ((Element)n).getElementsByTagName("keyName").item(0).getTextContent();
                keyDescs[i][1] = this.xpath.compile(((Element)n).getElementsByTagName("keyXPath").item(0).getTextContent());
                log.debug("Xpath: " + ((Element)n).getElementsByTagName("keyXPath").item(0).getTextContent());
            }
        }
        catch (Exception e) {
            log.error("Failed to parse and compile the key descriptions.", (Throwable)e);
            throw new Exception("Failed to parse and compile the key descriptions.", e);
        }
        this.transformByXSLT(sources, compiledXSLT, targetContentType, sink, keyDescs);
    }

    private void transformByXSLT(List<DataSource> sources, Templates compiledXSLT, ContentType targetContentType, DataSink sink, Object[][] keyDescs) throws Exception {
        if (sources.size() != 1) {
            throw new Exception("Elm2ElmProgram is only applicable for programs with one Input");
        }
        DataSource source = sources.get(0);
        while (source.hasNext()) {
            log.debug("Source has next...");
            DataElement object = source.next();
            if (object != null) {
                DataElement transformedObject;
                try {
                    log.debug("Got next object with id " + object.getId());
                    transformedObject = this.transformDataElementByXSLT(object, compiledXSLT, targetContentType, keyDescs);
                    if (transformedObject == null) {
                        log.warn("Got null transformed object...");
                        throw new Exception();
                    }
                    transformedObject.setId(object.getId());
                    log.debug("Got transformed object with id: " + transformedObject.getId() + " and content format: " + transformedObject.getContentType().toString() + ", appending into the sink");
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "was transformed successfully to " + transformedObject.getContentType().toString()), (Record.Status)Record.Status.SUCCESSFUL, (Record.Type)Record.Type.TRANSFORMATION);
                }
                catch (Exception e) {
                    log.error("Could not transform Data Element, continuing to next...", (Throwable)e);
                    ReportManager.manageRecord((String)object.getId(), (String)("Data element with id " + object.getId() + " and content format " + object.getContentType().toString() + " " + "could not be transformed to " + targetContentType.toString()), (Record.Status)Record.Status.FAILED, (Record.Type)Record.Type.TRANSFORMATION);
                    continue;
                }
                sink.append(transformedObject);
                log.debug("Transformed object with id: " + transformedObject.getId() + ", was appended successfully");
                continue;
            }
            log.warn("Got null object from the data source");
        }
        log.debug("Source does not have any objects left, closing the sink...");
        sink.close();
    }

    private DataElement transformDataElementByXSLT(DataElement sourceDataElement, Templates compiledXSLT, ContentType targetContentType, Object[][] keyDescs) throws Exception {
        StrDataElement transformedElement = StrDataElement.getSinkDataElement((DataElement)sourceDataElement);
        transformedElement.setContentType(targetContentType);
        transformedElement.setId(sourceDataElement.getId());
        StringWriter output = new StringWriter();
        Transformer t = compiledXSLT.newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        if (sourceDataElement instanceof StrDataElement) {
            t.transform(new StreamSource(new StringReader(((StrDataElement)sourceDataElement).getStringContent())), new StreamResult(output));
        } else {
            t.transform(new StreamSource(sourceDataElement.getContent()), new StreamResult(output));
        }
        String transformedPayload = output.toString();
        Document transformedDoc = XMLStringParser.parseXMLString(transformedPayload);
        this.serializerSource.setNode(transformedDoc);
        Element elTuple = (Element)this.xpath.evaluate("/ROWSET/INSERT/TUPLE", transformedDoc, XPathConstants.NODE);
        Element elValue = (Element)elTuple.getElementsByTagName("VALUE").item(0);
        for (Object[] keyDesc : keyDescs) {
            String keyName = (String)keyDesc[0];
            XPathExpression keyXPath = (XPathExpression)keyDesc[1];
            NodeList keyValueList = null;
            keyValueList = sourceDataElement instanceof StrDataElement ? (NodeList)keyXPath.evaluate(new InputSource(new StringReader(((StrDataElement)sourceDataElement).getStringContent())), XPathConstants.NODESET) : (NodeList)keyXPath.evaluate(new InputSource(sourceDataElement.getContent()), XPathConstants.NODESET);
            if (keyValueList == null || keyValueList.getLength() <= 0) continue;
            for (int z = 0; z < keyValueList.getLength(); ++z) {
                String keyValue = keyValueList.item(z).getTextContent();
                log.debug("keyValue " + z + ": " + keyValue);
                if (keyValue.trim().length() <= 0) continue;
                Element elKeyName = transformedDoc.createElement("KEYNAME");
                elKeyName.setTextContent(keyName);
                Element elKeyValue = transformedDoc.createElement("KEYVALUE");
                elKeyValue.setTextContent(keyValue);
                Element elKey = transformedDoc.createElement("KEY");
                elKey.appendChild(elKeyName);
                elKey.appendChild(elKeyValue);
                elTuple.insertBefore(elKey, elValue);
            }
        }
        Element elKeyName = transformedDoc.createElement("KEYNAME");
        elKeyName.setTextContent("ObjectID");
        Element elKeyValue = transformedDoc.createElement("KEYVALUE");
        elKeyValue.setTextContent(sourceDataElement.getAttributeValue("ContentOID"));
        Element elKey = transformedDoc.createElement("KEY");
        elKey.appendChild(elKeyName);
        elKey.appendChild(elKeyValue);
        elTuple.insertBefore(elKey, elValue);
        elKeyName = transformedDoc.createElement("KEYNAME");
        elKeyName.setTextContent("gDocCollectionID");
        elKeyValue = transformedDoc.createElement("KEYVALUE");
        elKeyValue.setTextContent(sourceDataElement.getAttributeValue("ContentCollectionID"));
        elKey = transformedDoc.createElement("KEY");
        elKey.appendChild(elKeyName);
        elKey.appendChild(elKeyValue);
        elTuple.insertBefore(elKey, elValue);
        elKeyName = transformedDoc.createElement("KEYNAME");
        elKeyName.setTextContent("gDocCollectionLang");
        elKeyValue = transformedDoc.createElement("KEYVALUE");
        elKeyValue.setTextContent(sourceDataElement.getAttributeValue("language"));
        elKey = transformedDoc.createElement("KEY");
        elKey.appendChild(elKeyName);
        elKey.appendChild(elKeyValue);
        elTuple.insertBefore(elKey, elValue);
        Element elfield = transformedDoc.createElement("FIELD");
        elfield.setTextContent(sourceDataElement.getAttributeValue("ContentOID"));
        elfield.setAttribute("name", "ObjectID");
        elValue.appendChild(elfield);
        elfield = transformedDoc.createElement("FIELD");
        elfield.setTextContent(sourceDataElement.getAttributeValue("ContentCollectionID"));
        elfield.setAttribute("name", "gDocCollectionID");
        elValue.appendChild(elfield);
        elfield = transformedDoc.createElement("FIELD");
        elfield.setTextContent(sourceDataElement.getAttributeValue("language"));
        elfield.setAttribute("name", "gDocCollectionLang");
        elValue.appendChild(elfield);
        StringWriter sw = new StringWriter();
        StreamResult sresult = new StreamResult(sw);
        this.serializer.transform(this.serializerSource, sresult);
        String result = sw.getBuffer().toString();
        transformedElement.setContent(result);
        return transformedElement;
    }
}

