/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.utils;

import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.datatransformation.datatransformationlibrary.PropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MimeUtils {
    private static HashMap<String, String> mime2ext = new HashMap();
    private static HashMap<String, String> ext2mime = new HashMap();
    private static Logger log;

    public static void main(String[] args) {
        System.out.println(MimeUtils.getFileExtension("video/x-flv"));
    }

    public static String getFileExtension(String mimeType) {
        String ext = mime2ext.get(mimeType.toLowerCase());
        if (ext == null) {
            return mimeType.split("/")[1];
        }
        return ext;
    }

    public static String getMimeType(String extension) {
        String mime = ext2mime.get(extension.toLowerCase());
        if (mime == null) {
            return "unknown/unknown";
        }
        return mime;
    }

    private static void load() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document resourceDoc = builder.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(PropertiesManager.getPropertyValue("utils.mime_mappings_file", "dts_mime_mappings.xml")));
            NodeList mappings = resourceDoc.getElementsByTagName("mime-mapping");
            for (int i = 0; i < mappings.getLength(); ++i) {
                try {
                    Element mapping = (Element)mappings.item(i);
                    String extension = ((Element)mapping.getElementsByTagName("extension").item(0)).getTextContent();
                    String mimetype = ((Element)mapping.getElementsByTagName("mime-type").item(0)).getTextContent();
                    mime2ext.put(mimetype.toLowerCase(), extension.toLowerCase());
                    ext2mime.put(extension.toLowerCase(), mimetype.toLowerCase());
                    continue;
                }
                catch (Exception e) {
                    log.error("Caught exception", (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            log.error("Did not manage to read mime - extension map");
        }
    }

    static {
        MimeUtils.load();
        log = LoggerFactory.getLogger(MimeUtils.class);
    }
}

