/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesUtils {
    private static Logger log = LoggerFactory.getLogger(FilesUtils.class);

    public static void streamToFile(InputStream instream, String filename) throws Exception {
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(new File(filename));
            byte[] buf = new byte[4096];
            while ((len = instream.read(buf)) >= 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            instream.close();
            instream = null;
            ((OutputStream)out).close();
            out = null;
        }
        catch (Exception e) {
            if (instream != null) {
                instream.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
            log.error("Could not persist stream. Throwing Exception", (Throwable)e);
            throw new Exception("Could not persist stream", e);
        }
    }
}

