/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model.graph;

import java.util.ArrayList;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPEnvelope;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.IManager;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TransformationsGraph;
import org.w3c.dom.Element;

public class RemoteTransformationsGraph
implements TransformationsGraph {
    private IManager iManager;
    private Call call;
    private String remoteGraphEndpoint;

    public RemoteTransformationsGraph(IManager iManager, String remoteGraphEndpoint) throws Exception {
        this.iManager = iManager;
        this.remoteGraphEndpoint = remoteGraphEndpoint;
        Service service = new Service();
        this.call = (Call)service.createCall();
        this.call.setTargetEndpointAddress(remoteGraphEndpoint);
    }

    @Override
    public ArrayList<TransformationUnit> findApplicableTransformationUnits(ContentType sourceContentType, ContentType targetContentType, boolean createAndPublishCompositeTP) {
        System.out.println("Going to get non generic transformationUnit Units from " + this.remoteGraphEndpoint);
        try {
            Message trsmsg = new Message((Object)("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><findApplicableTransformationUnits xmlns=\"http://gcube-system.org/namespaces/datatransformation/DataTransformationService\"><sourceContentType xmlns=\"\"><mimeType>" + sourceContentType.getMimeType() + "</mimeType></sourceContentType>" + "<targetContentType xmlns=\"\"><mimeType>" + targetContentType.getMimeType() + "</mimeType></targetContentType>" + "<createAndPublishCompositeTP xmlns=\"\">" + createAndPublishCompositeTP + "</createAndPublishCompositeTP>" + "</findApplicableTransformationUnits>" + "</soapenv:Body></soapenv:Envelope>"));
            SOAPEnvelope response = this.call.invoke(trsmsg);
            Element tpandtr = (Element)response.getAsDOM().getElementsByTagName("TPAndTransformationUnitIDs").item(0);
            String transformationProgramID = tpandtr.getElementsByTagName("transformationProgramID").item(0).getTextContent();
            String transformationUnitID = tpandtr.getElementsByTagName("transformationUnitID").item(0).getTextContent();
            System.out.println("Transformation Unit: " + transformationProgramID + "/" + transformationUnitID);
            if (transformationProgramID == null || transformationProgramID.trim().length() == 0 || transformationUnitID == null || transformationUnitID.trim().length() == 0) {
                throw new Exception("Could not find any transformationUnit");
            }
            ArrayList<TransformationUnit> transformationUnits = new ArrayList<TransformationUnit>();
            transformationUnits.add(this.iManager.getTransformationUnit(transformationProgramID, transformationUnitID));
            return transformationUnits;
        }
        catch (Exception e) {
            System.out.println("Did not manage to find applicable transformationUnit unit from " + sourceContentType + " to " + targetContentType);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ArrayList<TransformationUnit> findAnyTransformationUnits(ContentType sourceContentType, ContentType targetContentType, boolean createAndPublishCompositeTP) {
        return null;
    }

    @Override
    public ArrayList<ContentType> findAvailableTargetContentTypes(ContentType sourceContentType) {
        return null;
    }

    @Override
    public void destroy() {
    }
}

