package org.gcube.datatransformation.datatransformationlibrary.utils;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize.Inclusion;

import com.google.gson.Gson;

public class JSONConverter {
	private static final Gson gson = new Gson();
	private static final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(Inclusion.NON_NULL).enable(SerializationConfig.Feature.INDENT_OUTPUT);
	public static String toJSON(Object obj){
		return toJSON(obj, false);
	}
	
	public static String toJSON(Object obj, boolean prettyPrint) {
		String json = null;
		if (prettyPrint){
			try {
				json = mapper.writeValueAsString(obj);
			} catch (JsonGenerationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (JsonMappingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else
			json = gson.toJson(obj);
		
		return json;
	}
	
	public static String toJSON(String key, String value) {
		return "{\"" + key + "\" : \"" + value + "\"}";
	}
}
