/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.transformation.model;

import java.net.URI;
import java.util.ArrayList;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Input;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Output;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.gcube.datatransformation.datatransformationlibrary.transformation.model.TransformationPath;

public class TransformationDescription {
    private Input input;
    private Output output;
    private boolean createAndPublish = false;
    private ArrayList<TransformationPath> tPaths = new ArrayList();
    private int numOfPlansAdded = 0;
    private URI locator = null;
    private String returnedValue = null;

    public String getReturnedValue() {
        return this.returnedValue;
    }

    public void setReturnedValue(String returnedValue) {
        this.returnedValue = returnedValue;
    }

    public TransformationDescription(Input input, Output output) {
        this.input = input;
        this.output = output;
    }

    public TransformationDescription(Input input, Output output, boolean createAndPublish) {
        this(input, output);
        this.createAndPublish = createAndPublish;
    }

    public Input getInput() {
        return this.input;
    }

    public Output getOutput() {
        return this.output;
    }

    public boolean isCreateAndPublish() {
        return this.createAndPublish;
    }

    public void setCreateAndPublish(boolean createAndPublish) {
        this.createAndPublish = createAndPublish;
    }

    public ArrayList<ContentType> getContentTypes(int index) {
        return this.tPaths.get(index).getContentTypes();
    }

    public ArrayList<TransformationUnit> getTransformationPath(int index) {
        return this.tPaths.get(index).gettPath();
    }

    public void add(ArrayList<TransformationUnit> transformationUnits, ArrayList<ContentType> contentTypes) {
        this.tPaths.add(new TransformationPath(transformationUnits, contentTypes));
    }

    public int getNumOfPlansAdded() {
        return this.numOfPlansAdded;
    }

    public void setNumOfPlansAdded(int numOfPlansAdded) {
        this.numOfPlansAdded = numOfPlansAdded;
    }

    public boolean hasMorePlansToBeAdded() {
        return this.numOfPlansAdded < this.tPaths.size();
    }

    public URI getLocator() {
        return this.locator;
    }

    public void setLocator(URI locator) {
        this.locator = locator;
    }
}

