/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.tmpfilemanagement;

import java.io.File;
import java.util.UUID;
import org.gcube.datatransformation.datatransformationlibrary.tmpfilemanagement.GarbageCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileManager {
    public static final String DTSTMPDIR;
    public static final String DTSExtention = ".dts";
    public static boolean win;
    private static Logger log;
    private static GarbageCollector dtsGarbageCollector;

    public static String generateTempFileName(String tmpSubDir) throws Exception {
        File tmpSubDirFile;
        if (tmpSubDir == null) {
            tmpSubDir = TempFileManager.genarateTempSubDir();
        }
        if (!(tmpSubDirFile = new File(tmpSubDir)).exists()) {
            log.warn("Temp subdirectory does not exist recreating it...");
            if (!tmpSubDirFile.mkdirs()) {
                throw new Exception("Temp subdirectory could not be recreated");
            }
        }
        return tmpSubDir + TempFileManager.nextUUID() + DTSExtention;
    }

    public static String genarateTempSubDir() throws Exception {
        try {
            File dtsTmpDir = new File(DTSTMPDIR);
            if (!dtsTmpDir.exists()) {
                boolean succeeded = dtsTmpDir.mkdirs();
                if (!win) {
                    Runtime.getRuntime().exec("chmod 0777 " + dtsTmpDir.getAbsolutePath());
                }
                if (!succeeded) {
                    log.error("Could not create DTS TMP Directory " + DTSTMPDIR + " Throwing Exception");
                    throw new Exception("Could not create DTS TMP Directory " + DTSTMPDIR);
                }
            }
            String subDirName = TempFileManager.nextUUID();
            File subDirFile = new File(DTSTMPDIR + subDirName);
            if (!subDirFile.exists()) {
                boolean succeeded = subDirFile.mkdirs();
                if (!win) {
                    Runtime.getRuntime().exec("chmod 0777 " + subDirFile.getAbsolutePath());
                }
                if (!succeeded && !subDirFile.exists()) {
                    log.error("Could not create subase directory " + DTSTMPDIR + subDirName + " Throwing Exception");
                    throw new Exception("Could not create subase directory " + DTSTMPDIR + subDirName);
                }
            }
            return DTSTMPDIR + subDirName + File.separatorChar;
        }
        catch (Exception e) {
            log.error("Could not create temporary sub directory in " + DTSTMPDIR + " Throwing Exception", (Throwable)e);
            throw new Exception("Could not create temporary sub directory in " + DTSTMPDIR);
        }
    }

    public static void clearTemporaryDirectory() {
        dtsGarbageCollector.forceTempFilesDeletion();
    }

    private static String nextUUID() {
        return UUID.randomUUID().toString();
    }

    static {
        File tmpDTSDIRF;
        log = LoggerFactory.getLogger(TempFileManager.class);
        String tmpDIR = System.getProperty("java.io.tmpdir");
        DTSTMPDIR = tmpDIR != null && tmpDIR.trim().length() > 0 ? tmpDIR + File.separator + "dts" + File.separator : "/tmp/dts/";
        log.debug("Temporary file is " + DTSTMPDIR);
        win = File.separator.equals("\\");
        if (win) {
            log.debug("Running in windows");
        }
        if (!(tmpDTSDIRF = new File(DTSTMPDIR)).exists() && !tmpDTSDIRF.mkdirs()) {
            log.error("Did not manage to create DTS's temporary directory");
        }
        dtsGarbageCollector = new GarbageCollector(tmpDTSDIRF);
    }
}

