/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.statistics;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import org.gcube.datatransformation.datatransformationlibrary.PropertiesManager;

public class Metric {
    private String name;
    private String description;
    private int maxNumMeasures = PropertiesManager.getIntPropertyValue("statistics.maxnummeasures", "100");
    private Queue<Long> measures = new LinkedList<Long>();
    private long minMeasure = Long.MAX_VALUE;
    private long maxMeasure = Long.MIN_VALUE;
    private long sumOfMeasures = 0L;
    private long numMeasures = 0L;

    public Metric(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public Metric(String name, String description, int maxNumMeasures) {
        this.name = name;
        this.description = description;
        this.maxNumMeasures = maxNumMeasures;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addMeasure(Long measuredVal) {
        if (measuredVal < this.minMeasure) {
            this.minMeasure = measuredVal;
        }
        if (measuredVal > this.maxMeasure) {
            this.maxMeasure = measuredVal;
        }
        if (this.numMeasures < (long)this.maxNumMeasures) {
            this.sumOfMeasures += measuredVal.longValue();
            ++this.numMeasures;
        } else {
            this.sumOfMeasures = this.sumOfMeasures - this.measures.poll() + measuredVal;
        }
        this.measures.add(measuredVal);
    }

    public long getMinMeasure() {
        if (this.numMeasures == 0L) {
            return 0L;
        }
        return this.minMeasure;
    }

    public long getMaxMeasure() {
        if (this.numMeasures == 0L) {
            return 0L;
        }
        return this.maxMeasure;
    }

    public long getMeanOfMeasures() {
        if (this.numMeasures == 0L) {
            return 0L;
        }
        return this.sumOfMeasures / this.numMeasures;
    }

    public void reset() {
        this.measures.clear();
        this.minMeasure = Long.MAX_VALUE;
        this.maxMeasure = Long.MIN_VALUE;
        this.sumOfMeasures = 0L;
        this.numMeasures = 0L;
    }

    public static long getMeanValueOfMetrics(Collection<Metric> metrics) {
        long totalNumOfMeasures = 0L;
        long totalMeanValue = 0L;
        for (Metric metric : metrics) {
            totalNumOfMeasures += metric.numMeasures;
        }
        if (totalNumOfMeasures == 0L) {
            return 0L;
        }
        for (Metric metric : metrics) {
            totalMeanValue += metric.getMeanOfMeasures() * metric.numMeasures / totalNumOfMeasures;
        }
        return totalMeanValue;
    }
}

