/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.utils.XMLUtils;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.ContentTypeEvaluator;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSource;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Input;
import org.gcube.datatransformation.datatransformationlibrary.datahandlers.model.Output;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IOHandler {
    private static Logger log = LoggerFactory.getLogger(IOHandler.class);
    private static Map<String, Class> inputTypeToDataSourceClass = new HashMap<String, Class>();
    private static Map<String, Class> outputTypeToDataSinkClass = new HashMap<String, Class>();
    private static Map<String, Class> evaluatorTypeToEvaluatorClass = new HashMap<String, Class>();
    private static final Class[] dataHandlerConstructorParameterTypes = new Class[]{String.class, Parameter[].class};

    public static void init(String dataHandlersConfigFile) throws Exception {
        try {
            Document doc = XMLUtils.newDocument((InputStream)(dataHandlersConfigFile == null ? IOHandler.class.getResourceAsStream("/DataHandlersConfig.xml") : new FileInputStream(dataHandlersConfigFile)));
            NodeList dataSources = doc.getElementsByTagName("DataSource");
            for (int i = 0; i < dataSources.getLength(); ++i) {
                Element dataSource = (Element)dataSources.item(i);
                String type = dataSource.getAttribute("type");
                String className = dataSource.getAttribute("class");
                log.debug("Data Source found " + type + ": " + className);
                try {
                    Class<?> cls = Class.forName(className);
                    inputTypeToDataSourceClass.put(type, cls);
                    continue;
                }
                catch (Exception e) {
                    log.error("Did not manage to find in classpath class with name " + className, (Throwable)e);
                    continue;
                }
                catch (Error err) {
                    log.error("Did not manage to find in classpath class with name " + className, (Throwable)err);
                }
            }
            NodeList dataSinks = doc.getElementsByTagName("DataSink");
            for (int i = 0; i < dataSinks.getLength(); ++i) {
                Element dataSink = (Element)dataSinks.item(i);
                String type = dataSink.getAttribute("type");
                String className = dataSink.getAttribute("class");
                log.debug("Data Sink found " + type + ": " + className);
                try {
                    Class<?> cls = Class.forName(className);
                    outputTypeToDataSinkClass.put(type, cls);
                    continue;
                }
                catch (Exception e) {
                    log.error("Did not manage to find in classpath class with name " + className, (Throwable)e);
                    continue;
                }
                catch (Error err) {
                    log.error("Did not manage to find in classpath class with name " + className, (Throwable)err);
                }
            }
            NodeList contentTypeEvaluators = doc.getElementsByTagName("ContentTypeEvaluator");
            for (int i = 0; i < contentTypeEvaluators.getLength(); ++i) {
                Element contentTypeEvaluator = (Element)contentTypeEvaluators.item(i);
                String type = contentTypeEvaluator.getAttribute("type");
                String className = contentTypeEvaluator.getAttribute("class");
                log.debug("Data Sink found " + type + ": " + className);
                try {
                    Class<?> cls = Class.forName(className);
                    evaluatorTypeToEvaluatorClass.put(type, cls);
                    continue;
                }
                catch (Exception e) {
                    log.error("Did not manage to find in classpath class with name " + className, (Throwable)e);
                    continue;
                }
                catch (Error err) {
                    log.error("Did not manage to find in classpath class with name " + className, (Throwable)err);
                }
            }
        }
        catch (Exception e) {
            log.error("Could not parse configuration file for Data Handlers", (Throwable)e);
            throw new Exception("Could not parse configuration file for Data Handlers", e);
        }
    }

    public static DataSource getDataSource(Input input) throws Exception {
        if (inputTypeToDataSourceClass == null) {
            log.error("IOHandler is not initialized");
            throw new Exception("IOHandler is not initialized");
        }
        if (input == null) {
            log.error("Input is not set");
            throw new Exception("Input is not set");
        }
        String inputType = input.getInputType();
        String inputValue = input.getInputValue();
        Parameter[] inputParameters = input.getInputparameters();
        if (inputType == null || inputType == null) {
            log.error("Input type is not set");
            throw new Exception("Input type is not set");
        }
        if (inputValue == null) {
            log.error("Input value is not set");
            throw new Exception("Input value is not set");
        }
        Class dataSourceClass = inputTypeToDataSourceClass.get(inputType);
        if (dataSourceClass == null) {
            log.error("Could not find data source with " + inputType + " IOType.");
            throw new Exception("Could not find data source with IOType " + inputType);
        }
        try {
            Constructor sourceConstructor = dataSourceClass.getConstructor(dataHandlerConstructorParameterTypes);
            return (DataSource)sourceConstructor.newInstance(inputValue, inputParameters);
        }
        catch (Exception e) {
            log.error("Error when instanciating the data source.", (Throwable)e);
            throw new Exception("Error when instanciating the data source", e);
        }
    }

    public static ContentTypeEvaluator getContentTypeEvaluator(String evaluatorType) throws Exception {
        if (evaluatorTypeToEvaluatorClass == null) {
            log.error("IOHandler is not initialized");
            throw new Exception("IOHandler is not initialized");
        }
        if (evaluatorType == null || evaluatorType.trim().length() == 0) {
            log.error("Evaluator type is not set");
            throw new Exception("Evaluator type is not set");
        }
        Class evaluatorClass = evaluatorTypeToEvaluatorClass.get(evaluatorType);
        if (evaluatorClass == null) {
            log.error("Could not find evaluator with type: " + evaluatorType);
            throw new Exception("Could not find evaluator with type: " + evaluatorType);
        }
        try {
            return (ContentTypeEvaluator)evaluatorClass.newInstance();
        }
        catch (Exception e) {
            log.error("Error when instanciating the Content Type Evaluator", (Throwable)e);
            throw new Exception("Error when instanciating the Content Type Evaluator");
        }
    }

    public static DataSink getDataSink(Output output) throws Exception {
        if (outputTypeToDataSinkClass == null) {
            log.error("IOHandler is not initialized");
            throw new Exception("IOHandler is not initialized");
        }
        if (output == null) {
            log.error("Output is not set");
            throw new Exception("Output is not set");
        }
        String outputType = output.getOutputType();
        String outputValue = output.getOutputValue();
        Parameter[] outputParameters = output.getOutputparameters();
        if (outputType == null || outputType == null) {
            log.error("Output type is not set properly");
            return null;
        }
        Class dataSinkClass = outputTypeToDataSinkClass.get(outputType);
        if (dataSinkClass == null) {
            log.error("Could not find data sink with " + outputType + " IOType.");
            throw new Exception("Could not find data sink with IOType " + outputType);
        }
        try {
            Constructor sinkConstructor = dataSinkClass.getConstructor(dataHandlerConstructorParameterTypes);
            return (DataSink)sinkConstructor.newInstance(outputValue, outputParameters);
        }
        catch (Exception e) {
            log.error("Error when instanciating the data sink.", (Throwable)e);
            throw new Exception("Error when instanciating the data sink", e);
        }
    }
}

