/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model;

import org.gcube.datatransformation.datatransformationlibrary.datahandlers.DataSink;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationRuleElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Target
extends TransformationRuleElement {
    private String outputID;

    public void setOutputID(String id) {
        this.outputID = id;
    }

    public String getOutputID() {
        return this.outputID;
    }

    public DataSink getOutput() throws Exception {
        return (DataSink)this.transformationUnit.getDataHandler(this.outputID);
    }

    protected void fromDOM(Element targetElm) {
        Element contentformatElm;
        Element outputElm = (Element)targetElm.getElementsByTagName("Output").item(0);
        if (outputElm != null) {
            this.outputID = outputElm.getAttribute("id");
        }
        if ((contentformatElm = (Element)targetElm.getElementsByTagName("ContentType").item(0)) != null) {
            this.contentType = new ContentType();
            this.contentType.fromDOM(contentformatElm);
        }
    }

    protected void toDOM(Element transformationElm) {
        Document doc = transformationElm.getOwnerDocument();
        Element targetElm = doc.createElement("Target");
        Element outputElm = doc.createElement("Output");
        Attr ioID = doc.createAttribute("id");
        ioID.setTextContent(this.outputID);
        outputElm.setAttributeNode(ioID);
        targetElm.appendChild(outputElm);
        this.contentType.toDOM(targetElm);
        transformationElm.appendChild(targetElm);
    }
}

