/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.imanagers;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.IManager;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.DescriptionQueryObject;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.QueryObject;
import org.gcube.datatransformation.datatransformationlibrary.imanagers.queries.QueryParser;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationProgram;
import org.gcube.datatransformation.datatransformationlibrary.model.TransformationUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LocalInfoManager
implements IManager {
    private static Logger log = LoggerFactory.getLogger(LocalInfoManager.class);
    private String programsFile;
    private Document programsDoc;

    @Override
    public TransformationProgram getTransformationProgram(String transformationProgramID) throws Exception {
        this.parseDocument();
        Element resource = null;
        NodeList resources = this.programsDoc.getElementsByTagName("Resource");
        for (int i = 0; i < resources.getLength(); ++i) {
            if (!((Element)resources.item(i)).getElementsByTagName("ID").item(0).getTextContent().equals(transformationProgramID)) continue;
            resource = (Element)resources.item(i);
        }
        if (resource == null) {
            log.error("Resource (TP) with id " + transformationProgramID + " does not exist.");
            return null;
        }
        TransformationProgram programinst = new TransformationProgram();
        programinst.fromDOM(resource);
        return programinst;
    }

    @Override
    public TransformationUnit getTransformationUnit(String transformationProgramID, String transformationUnitID) throws Exception {
        TransformationProgram transformationProgram = this.getTransformationProgram(transformationProgramID);
        if (transformationProgram.getTransformationUnits() == null || transformationProgram.getTransformationUnits().size() == 0) {
            log.error("Transformation program with id " + transformationProgramID + " does not contain any transformations");
            throw new Exception("Transformation program with id " + transformationProgramID + " does not contain any transformations");
        }
        for (TransformationUnit transformation : transformationProgram.getTransformationUnits()) {
            if (!transformation.getId().equals(transformationUnitID)) continue;
            return transformation;
        }
        log.error("Did not manage to find transformationUnit with id " + transformationUnitID + " in transformationUnit program with id " + transformationProgramID);
        throw new Exception("Did not manage to find transformationUnit with id " + transformationUnitID + " in transformationUnit program with id " + transformationProgramID);
    }

    public void setProgramsFile(String programsFile) {
        this.programsFile = programsFile;
    }

    @Override
    public String[] getAvailableTransformationProgramIDs() throws Exception {
        this.parseDocument();
        ArrayList<String> ids = new ArrayList<String>();
        NodeList idels = this.programsDoc.getElementsByTagName("ID");
        for (int i = 0; i < idels.getLength(); ++i) {
            ids.add(((Element)idels.item(i)).getTextContent());
        }
        return ids.toArray(new String[ids.size()]);
    }

    @Override
    public void publishTransformationProgram(TransformationProgram transformationProgram) throws Exception {
        try {
            String xml = transformationProgram.toXML();
            log.info("Going to publish the following transformationUnit program\n" + xml);
        }
        catch (Exception e) {
            log.error("Could not publish transformationUnit program", (Throwable)e);
            throw new Exception("Could not publish transformationUnit program");
        }
    }

    @Override
    public String queryTransformationPrograms(String query) throws Exception {
        QueryObject object = QueryParser.parse(query);
        String result = null;
        if (!DescriptionQueryObject.class.isInstance(object)) {
            log.debug("Invalid query object type");
            throw new Exception("Invalid query object type");
        }
        log.debug("Quering for Description...");
        DescriptionQueryObject tobject = (DescriptionQueryObject)object;
        result = this.queryDescription(tobject);
        log.debug("Result of query: " + query + " is \n" + result);
        return result;
    }

    private String queryDescription(DescriptionQueryObject object) throws Exception {
        log.debug("Going to get description for " + object.transformationProgramID + "/" + object.transformationUnitID);
        if (object.transformationProgramID == null || object.transformationProgramID.trim().length() == 0) {
            throw new Exception("Cannot query for description without setting transformationUnit program id");
        }
        TransformationProgram tp = this.getTransformationProgram(object.transformationProgramID);
        if (object.transformationUnitID != null && object.transformationUnitID.trim().length() > 0) {
            TransformationUnit selected = null;
            for (TransformationUnit tr : tp.getTransformationUnits()) {
                if (!tr.getId().equals(object.transformationUnitID)) continue;
                selected = tr;
            }
            if (selected == null) {
                throw new Exception("Could not find transformationUnit with id " + object.transformationUnitID + " in TransformationProgram " + object.transformationProgramID);
            }
            ArrayList<TransformationUnit> tUnits = new ArrayList<TransformationUnit>();
            tUnits.add(selected);
            tp.setTransformationUnits(tUnits);
        }
        return "<Result>" + tp.toXML() + "</Result>";
    }

    private void parseDocument() throws Exception {
        if (this.programsFile == null) {
            log.error("Programs file not specified");
            throw new Exception("Programs file not specified");
        }
        if (this.programsDoc == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.programsDoc = builder.parse(new File(this.programsFile));
            }
            catch (Exception e) {
                log.error("Could not parse the ProgramsFile: " + this.programsFile, (Throwable)e);
                throw new Exception("Could not parse the ProgramsFile: " + this.programsFile);
            }
        }
    }
}

