/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.reports;

import java.util.ArrayList;
import org.gcube.datatransformation.datatransformationlibrary.reports.RecordStruct;
import org.gcube.datatransformation.datatransformationlibrary.reports.Report;

public class Record {
    protected String objectID;
    protected String sourceRec;
    protected Status sourceStatus;
    protected String filterRec;
    protected Status passFilterStatus;
    protected ArrayList<RecordStruct> transformationRecs = new ArrayList();
    protected String sinkRec;
    protected Status sinkStatus;
    protected Report report;

    public void setRecord(String message, Status status, Type type) {
        switch (type) {
            case SOURCE: {
                this.sourceRec = message;
                this.sourceStatus = status;
                if (!status.equals((Object)Status.FAILED)) break;
                this.report.commitRecord(this);
                break;
            }
            case FILTER: {
                this.filterRec = message;
                this.passFilterStatus = status;
                if (!status.equals((Object)Status.FAILED)) break;
                this.report.commitRecord(this);
                break;
            }
            case TRANSFORMATION: {
                RecordStruct struct = new RecordStruct();
                struct.message = message;
                struct.status = status;
                this.transformationRecs.add(struct);
                if (!status.equals((Object)Status.FAILED)) break;
                this.report.commitRecord(this);
                break;
            }
            case SINK: {
                this.sinkRec = message;
                this.sinkStatus = status;
                this.report.commitRecord(this);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<REPORTREC>");
        builder.append("<OBJECTID>");
        builder.append(this.objectID);
        builder.append("</OBJECTID>");
        if (this.sourceRec != null && this.sourceStatus != null) {
            builder.append("<SOURCE>");
            builder.append("<MSG>" + this.sourceRec + "</MSG>");
            builder.append("<STATUS>" + (Object)((Object)this.sourceStatus) + "</STATUS>");
            builder.append("</SOURCE>");
        }
        if (this.filterRec != null && this.passFilterStatus != null) {
            builder.append("<FILTER>");
            builder.append("<MSG>" + this.filterRec + "</MSG>");
            builder.append("<STATUS>" + (Object)((Object)this.passFilterStatus) + "</STATUS>");
            builder.append("</FILTER>");
        }
        if (this.transformationRecs != null && this.transformationRecs.size() > 0) {
            for (RecordStruct struct : this.transformationRecs) {
                builder.append("<TRANSFORMATION>");
                builder.append("<MSG>" + struct.message + "</MSG>");
                builder.append("<STATUS>" + (Object)((Object)struct.status) + "</STATUS>");
                builder.append("</TRANSFORMATION>");
            }
        }
        if (this.sinkRec != null && this.sinkStatus != null) {
            builder.append("<SINK>");
            builder.append("<MSG>" + this.sinkRec + "</MSG>");
            builder.append("<STATUS>" + (Object)((Object)this.sinkStatus) + "</STATUS>");
            builder.append("</SINK>");
        }
        builder.append("</REPORTREC>");
        return builder.toString();
    }

    public static enum Type {
        SOURCE,
        FILTER,
        TRANSFORMATION,
        SINK;

    }

    public static enum Status {
        SUCCESSFUL,
        FAILED;

    }
}

