/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.model.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.datatransformation.datatransformationlibrary.model.ContentType;
import org.gcube.datatransformation.datatransformationlibrary.model.Parameter;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TNode;
import org.gcube.datatransformation.datatransformationlibrary.model.graph.TNodeWithUnbound;

public class NodesCollection {
    private HashMap<String, ArrayList<TNode>> nodesbyMT = new HashMap();

    public TNode add(ContentType contentType) {
        TNode newnode = new TNode(contentType);
        ArrayList<TNode> nodesofMT = this.nodesbyMT.get(contentType.getMimeType().toLowerCase());
        if (nodesofMT == null) {
            nodesofMT = new ArrayList();
            this.nodesbyMT.put(contentType.getMimeType().toLowerCase(), nodesofMT);
        }
        nodesofMT.add(newnode);
        return newnode;
    }

    public boolean exists(ContentType contentType) {
        return this.get(contentType) != null;
    }

    public TNode get(ContentType contentType) {
        ArrayList<TNode> nodesofMT = this.nodesbyMT.get(contentType.getMimeType().toLowerCase());
        if (nodesofMT == null) {
            return null;
        }
        for (int i = 0; i < nodesofMT.size(); ++i) {
            if (!Parameter.equals(nodesofMT.get(i).getContentTypeParameters(), contentType.getContentTypeParameters())) continue;
            return nodesofMT.get(i);
        }
        return null;
    }

    public ArrayList<TNodeWithUnbound> getExactlySupportedWithUnbound(ContentType contentType) {
        ArrayList<TNodeWithUnbound> exactsupported = new ArrayList<TNodeWithUnbound>();
        TNode node = this.get(contentType);
        if (node != null) {
            exactsupported.add(new TNodeWithUnbound(node, null));
        }
        return exactsupported;
    }

    public TNode getExactlySupported(ContentType contentType) {
        return this.get(contentType);
    }

    public ArrayList<TNodeWithUnbound> getAnyThatSupportWithUnbound(ContentType contentType) {
        ArrayList<TNodeWithUnbound> supported = new ArrayList<TNodeWithUnbound>();
        ArrayList<TNode> nodesofMT = this.nodesbyMT.get(contentType.getMimeType().toLowerCase());
        if (nodesofMT == null) {
            return null;
        }
        for (int i = 0; i < nodesofMT.size(); ++i) {
            List<Parameter> unbound = ContentType.supportAndFillUnbound(nodesofMT.get(i).getContentTypeParameters(), contentType.getContentTypeParameters());
            if (unbound == null) continue;
            TNodeWithUnbound twunbound = new TNodeWithUnbound(nodesofMT.get(i), unbound);
            twunbound.setRefsToSource();
            supported.add(twunbound);
        }
        return supported;
    }

    public ArrayList<TNode> getAnyThatSupport(ContentType contentType) {
        ArrayList<TNode> supported = new ArrayList<TNode>();
        ArrayList<TNode> nodesofMT = this.nodesbyMT.get(contentType.getMimeType().toLowerCase());
        if (nodesofMT == null) {
            return supported;
        }
        for (int i = 0; i < nodesofMT.size(); ++i) {
            if (!ContentType.support(nodesofMT.get(i).getContentTypeParameters(), contentType.getContentTypeParameters())) continue;
            supported.add(nodesofMT.get(i));
        }
        return supported;
    }

    public ArrayList<TNodeWithUnbound> getAnySupportedByWithUnbound(ContentType contentType) {
        ArrayList<TNodeWithUnbound> supported = new ArrayList<TNodeWithUnbound>();
        ArrayList<TNode> nodesofMT = this.nodesbyMT.get(contentType.getMimeType().toLowerCase());
        if (nodesofMT == null) {
            return null;
        }
        for (int i = 0; i < nodesofMT.size(); ++i) {
            List<Parameter> unbound = ContentType.supportAndFillUnbound(contentType.getContentTypeParameters(), nodesofMT.get(i).getContentTypeParameters());
            if (unbound == null) continue;
            TNodeWithUnbound twunbound = new TNodeWithUnbound(nodesofMT.get(i), unbound);
            twunbound.setRefsToTarget();
            supported.add(twunbound);
        }
        return supported;
    }

    public ArrayList<TNodeWithUnbound> getGenericallySupported(ContentType contentType) {
        ArrayList<TNodeWithUnbound> gensupported = new ArrayList<TNodeWithUnbound>();
        ArrayList<TNode> nodesofMT = this.nodesbyMT.get(contentType.getMimeType().toLowerCase());
        if (nodesofMT == null) {
            return null;
        }
        for (int i = 0; i < nodesofMT.size(); ++i) {
            if (!ContentType.gensupport(nodesofMT.get(i).getContentTypeParameters(), contentType.getContentTypeParameters())) continue;
            gensupported.add(new TNodeWithUnbound(nodesofMT.get(i), null));
        }
        return gensupported;
    }

    protected void clear() {
        this.nodesbyMT.clear();
    }
}

